//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesGetHandlerFunc turns a function with the right signature into a aliases get handler
type AliasesGetHandlerFunc func(AliasesGetParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn AliasesGetHandlerFunc) Handle(params AliasesGetParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// AliasesGetHandler interface for that can handle valid aliases get params
type AliasesGetHandler interface {
	Handle(AliasesGetParams, *models.Principal) middleware.Responder
}

// NewAliasesGet creates a new http.Handler for the aliases get operation
func NewAliasesGet(ctx *middleware.Context, handler AliasesGetHandler) *AliasesGet {
	return &AliasesGet{Context: ctx, Handler: handler}
}

/*
	AliasesGet swagger:route GET /aliases schema aliasesGet

# List aliases

Retrieve a list of all aliases in the system. Results can be filtered by specifying a collection (class) name to get aliases for a specific collection only.
*/
type AliasesGet struct {
	Context *middleware.Context
	Handler AliasesGetHandler
}

func (o *AliasesGet) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewAliasesGetParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
