//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
)

// NewAliasesGetAliasParams creates a new AliasesGetAliasParams object
//
// There are no default values defined in the spec.
func NewAliasesGetAliasParams() AliasesGetAliasParams {

	return AliasesGetAliasParams{}
}

// AliasesGetAliasParams contains all the bound params for the aliases get alias operation
// typically these are obtained from a http.Request
//
// swagger:parameters aliases.get.alias
type AliasesGetAliasParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*
	  Required: true
	  In: path
	*/
	AliasName string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewAliasesGetAliasParams() beforehand.
func (o *AliasesGetAliasParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	rAliasName, rhkAliasName, _ := route.Params.GetOK("aliasName")
	if err := o.bindAliasName(rAliasName, rhkAliasName, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindAliasName binds and validates parameter AliasName from path.
func (o *AliasesGetAliasParams) bindAliasName(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.AliasName = raw

	return nil
}
