//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesGetAliasOKCode is the HTTP code returned for type AliasesGetAliasOK
const AliasesGetAliasOKCode int = 200

/*
AliasesGetAliasOK Successfully retrieved the alias details.

swagger:response aliasesGetAliasOK
*/
type AliasesGetAliasOK struct {

	/*
	  In: Body
	*/
	Payload *models.Alias `json:"body,omitempty"`
}

// NewAliasesGetAliasOK creates AliasesGetAliasOK with default headers values
func NewAliasesGetAliasOK() *AliasesGetAliasOK {

	return &AliasesGetAliasOK{}
}

// WithPayload adds the payload to the aliases get alias o k response
func (o *AliasesGetAliasOK) WithPayload(payload *models.Alias) *AliasesGetAliasOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases get alias o k response
func (o *AliasesGetAliasOK) SetPayload(payload *models.Alias) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesGetAliasOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesGetAliasUnauthorizedCode is the HTTP code returned for type AliasesGetAliasUnauthorized
const AliasesGetAliasUnauthorizedCode int = 401

/*
AliasesGetAliasUnauthorized Unauthorized or invalid credentials.

swagger:response aliasesGetAliasUnauthorized
*/
type AliasesGetAliasUnauthorized struct {
}

// NewAliasesGetAliasUnauthorized creates AliasesGetAliasUnauthorized with default headers values
func NewAliasesGetAliasUnauthorized() *AliasesGetAliasUnauthorized {

	return &AliasesGetAliasUnauthorized{}
}

// WriteResponse to the client
func (o *AliasesGetAliasUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// AliasesGetAliasForbiddenCode is the HTTP code returned for type AliasesGetAliasForbidden
const AliasesGetAliasForbiddenCode int = 403

/*
AliasesGetAliasForbidden Forbidden

swagger:response aliasesGetAliasForbidden
*/
type AliasesGetAliasForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesGetAliasForbidden creates AliasesGetAliasForbidden with default headers values
func NewAliasesGetAliasForbidden() *AliasesGetAliasForbidden {

	return &AliasesGetAliasForbidden{}
}

// WithPayload adds the payload to the aliases get alias forbidden response
func (o *AliasesGetAliasForbidden) WithPayload(payload *models.ErrorResponse) *AliasesGetAliasForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases get alias forbidden response
func (o *AliasesGetAliasForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesGetAliasForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesGetAliasNotFoundCode is the HTTP code returned for type AliasesGetAliasNotFound
const AliasesGetAliasNotFoundCode int = 404

/*
AliasesGetAliasNotFound Not Found - Alias does not exist

swagger:response aliasesGetAliasNotFound
*/
type AliasesGetAliasNotFound struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesGetAliasNotFound creates AliasesGetAliasNotFound with default headers values
func NewAliasesGetAliasNotFound() *AliasesGetAliasNotFound {

	return &AliasesGetAliasNotFound{}
}

// WithPayload adds the payload to the aliases get alias not found response
func (o *AliasesGetAliasNotFound) WithPayload(payload *models.ErrorResponse) *AliasesGetAliasNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases get alias not found response
func (o *AliasesGetAliasNotFound) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesGetAliasNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesGetAliasUnprocessableEntityCode is the HTTP code returned for type AliasesGetAliasUnprocessableEntity
const AliasesGetAliasUnprocessableEntityCode int = 422

/*
AliasesGetAliasUnprocessableEntity Invalid alias name provided.

swagger:response aliasesGetAliasUnprocessableEntity
*/
type AliasesGetAliasUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesGetAliasUnprocessableEntity creates AliasesGetAliasUnprocessableEntity with default headers values
func NewAliasesGetAliasUnprocessableEntity() *AliasesGetAliasUnprocessableEntity {

	return &AliasesGetAliasUnprocessableEntity{}
}

// WithPayload adds the payload to the aliases get alias unprocessable entity response
func (o *AliasesGetAliasUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *AliasesGetAliasUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases get alias unprocessable entity response
func (o *AliasesGetAliasUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesGetAliasUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesGetAliasInternalServerErrorCode is the HTTP code returned for type AliasesGetAliasInternalServerError
const AliasesGetAliasInternalServerErrorCode int = 500

/*
AliasesGetAliasInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response aliasesGetAliasInternalServerError
*/
type AliasesGetAliasInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesGetAliasInternalServerError creates AliasesGetAliasInternalServerError with default headers values
func NewAliasesGetAliasInternalServerError() *AliasesGetAliasInternalServerError {

	return &AliasesGetAliasInternalServerError{}
}

// WithPayload adds the payload to the aliases get alias internal server error response
func (o *AliasesGetAliasInternalServerError) WithPayload(payload *models.ErrorResponse) *AliasesGetAliasInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases get alias internal server error response
func (o *AliasesGetAliasInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesGetAliasInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
