//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
)

// NewAliasesGetParams creates a new AliasesGetParams object
//
// There are no default values defined in the spec.
func NewAliasesGetParams() AliasesGetParams {

	return AliasesGetParams{}
}

// AliasesGetParams contains all the bound params for the aliases get operation
// typically these are obtained from a http.Request
//
// swagger:parameters aliases.get
type AliasesGetParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*Optional filter to retrieve aliases for a specific collection (class) only. If not provided, returns all aliases.
	  In: query
	*/
	Class *string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewAliasesGetParams() beforehand.
func (o *AliasesGetParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qClass, qhkClass, _ := qs.GetOK("class")
	if err := o.bindClass(qClass, qhkClass, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindClass binds and validates parameter Class from query.
func (o *AliasesGetParams) bindClass(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: false
	// AllowEmptyValue: false

	if raw == "" { // empty values pass all other validations
		return nil
	}
	o.Class = &raw

	return nil
}
