//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesGetOKCode is the HTTP code returned for type AliasesGetOK
const AliasesGetOKCode int = 200

/*
AliasesGetOK Successfully retrieved the list of aliases

swagger:response aliasesGetOK
*/
type AliasesGetOK struct {

	/*
	  In: Body
	*/
	Payload *models.AliasResponse `json:"body,omitempty"`
}

// NewAliasesGetOK creates AliasesGetOK with default headers values
func NewAliasesGetOK() *AliasesGetOK {

	return &AliasesGetOK{}
}

// WithPayload adds the payload to the aliases get o k response
func (o *AliasesGetOK) WithPayload(payload *models.AliasResponse) *AliasesGetOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases get o k response
func (o *AliasesGetOK) SetPayload(payload *models.AliasResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesGetOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesGetUnauthorizedCode is the HTTP code returned for type AliasesGetUnauthorized
const AliasesGetUnauthorizedCode int = 401

/*
AliasesGetUnauthorized Unauthorized or invalid credentials.

swagger:response aliasesGetUnauthorized
*/
type AliasesGetUnauthorized struct {
}

// NewAliasesGetUnauthorized creates AliasesGetUnauthorized with default headers values
func NewAliasesGetUnauthorized() *AliasesGetUnauthorized {

	return &AliasesGetUnauthorized{}
}

// WriteResponse to the client
func (o *AliasesGetUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// AliasesGetForbiddenCode is the HTTP code returned for type AliasesGetForbidden
const AliasesGetForbiddenCode int = 403

/*
AliasesGetForbidden Forbidden

swagger:response aliasesGetForbidden
*/
type AliasesGetForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesGetForbidden creates AliasesGetForbidden with default headers values
func NewAliasesGetForbidden() *AliasesGetForbidden {

	return &AliasesGetForbidden{}
}

// WithPayload adds the payload to the aliases get forbidden response
func (o *AliasesGetForbidden) WithPayload(payload *models.ErrorResponse) *AliasesGetForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases get forbidden response
func (o *AliasesGetForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesGetForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesGetUnprocessableEntityCode is the HTTP code returned for type AliasesGetUnprocessableEntity
const AliasesGetUnprocessableEntityCode int = 422

/*
AliasesGetUnprocessableEntity Invalid collection (class) parameter provided

swagger:response aliasesGetUnprocessableEntity
*/
type AliasesGetUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesGetUnprocessableEntity creates AliasesGetUnprocessableEntity with default headers values
func NewAliasesGetUnprocessableEntity() *AliasesGetUnprocessableEntity {

	return &AliasesGetUnprocessableEntity{}
}

// WithPayload adds the payload to the aliases get unprocessable entity response
func (o *AliasesGetUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *AliasesGetUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases get unprocessable entity response
func (o *AliasesGetUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesGetUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesGetInternalServerErrorCode is the HTTP code returned for type AliasesGetInternalServerError
const AliasesGetInternalServerErrorCode int = 500

/*
AliasesGetInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response aliasesGetInternalServerError
*/
type AliasesGetInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesGetInternalServerError creates AliasesGetInternalServerError with default headers values
func NewAliasesGetInternalServerError() *AliasesGetInternalServerError {

	return &AliasesGetInternalServerError{}
}

// WithPayload adds the payload to the aliases get internal server error response
func (o *AliasesGetInternalServerError) WithPayload(payload *models.ErrorResponse) *AliasesGetInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases get internal server error response
func (o *AliasesGetInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesGetInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
