//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"context"
	"net/http"

	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesUpdateHandlerFunc turns a function with the right signature into a aliases update handler
type AliasesUpdateHandlerFunc func(AliasesUpdateParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn AliasesUpdateHandlerFunc) Handle(params AliasesUpdateParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// AliasesUpdateHandler interface for that can handle valid aliases update params
type AliasesUpdateHandler interface {
	Handle(AliasesUpdateParams, *models.Principal) middleware.Responder
}

// NewAliasesUpdate creates a new http.Handler for the aliases update operation
func NewAliasesUpdate(ctx *middleware.Context, handler AliasesUpdateHandler) *AliasesUpdate {
	return &AliasesUpdate{Context: ctx, Handler: handler}
}

/*
	AliasesUpdate swagger:route PUT /aliases/{aliasName} schema aliasesUpdate

# Update an alias

Update an existing alias to point to a different collection (class). This allows you to redirect an alias from one collection to another without changing the alias name.
*/
type AliasesUpdate struct {
	Context *middleware.Context
	Handler AliasesUpdateHandler
}

func (o *AliasesUpdate) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewAliasesUpdateParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}

// AliasesUpdateBody aliases update body
//
// swagger:model AliasesUpdateBody
type AliasesUpdateBody struct {

	// The new collection (class) that the alias should point to.
	Class string `json:"class,omitempty" yaml:"class,omitempty"`
}

// Validate validates this aliases update body
func (o *AliasesUpdateBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this aliases update body based on context it is used
func (o *AliasesUpdateBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *AliasesUpdateBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AliasesUpdateBody) UnmarshalBinary(b []byte) error {
	var res AliasesUpdateBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
