//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesUpdateOKCode is the HTTP code returned for type AliasesUpdateOK
const AliasesUpdateOKCode int = 200

/*
AliasesUpdateOK Successfully updated the alias to point to the new collection (class).

swagger:response aliasesUpdateOK
*/
type AliasesUpdateOK struct {

	/*
	  In: Body
	*/
	Payload *models.Alias `json:"body,omitempty"`
}

// NewAliasesUpdateOK creates AliasesUpdateOK with default headers values
func NewAliasesUpdateOK() *AliasesUpdateOK {

	return &AliasesUpdateOK{}
}

// WithPayload adds the payload to the aliases update o k response
func (o *AliasesUpdateOK) WithPayload(payload *models.Alias) *AliasesUpdateOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases update o k response
func (o *AliasesUpdateOK) SetPayload(payload *models.Alias) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesUpdateOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesUpdateUnauthorizedCode is the HTTP code returned for type AliasesUpdateUnauthorized
const AliasesUpdateUnauthorizedCode int = 401

/*
AliasesUpdateUnauthorized Unauthorized or invalid credentials.

swagger:response aliasesUpdateUnauthorized
*/
type AliasesUpdateUnauthorized struct {
}

// NewAliasesUpdateUnauthorized creates AliasesUpdateUnauthorized with default headers values
func NewAliasesUpdateUnauthorized() *AliasesUpdateUnauthorized {

	return &AliasesUpdateUnauthorized{}
}

// WriteResponse to the client
func (o *AliasesUpdateUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// AliasesUpdateForbiddenCode is the HTTP code returned for type AliasesUpdateForbidden
const AliasesUpdateForbiddenCode int = 403

/*
AliasesUpdateForbidden Forbidden

swagger:response aliasesUpdateForbidden
*/
type AliasesUpdateForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesUpdateForbidden creates AliasesUpdateForbidden with default headers values
func NewAliasesUpdateForbidden() *AliasesUpdateForbidden {

	return &AliasesUpdateForbidden{}
}

// WithPayload adds the payload to the aliases update forbidden response
func (o *AliasesUpdateForbidden) WithPayload(payload *models.ErrorResponse) *AliasesUpdateForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases update forbidden response
func (o *AliasesUpdateForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesUpdateForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesUpdateNotFoundCode is the HTTP code returned for type AliasesUpdateNotFound
const AliasesUpdateNotFoundCode int = 404

/*
AliasesUpdateNotFound Not Found - Alias does not exist

swagger:response aliasesUpdateNotFound
*/
type AliasesUpdateNotFound struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesUpdateNotFound creates AliasesUpdateNotFound with default headers values
func NewAliasesUpdateNotFound() *AliasesUpdateNotFound {

	return &AliasesUpdateNotFound{}
}

// WithPayload adds the payload to the aliases update not found response
func (o *AliasesUpdateNotFound) WithPayload(payload *models.ErrorResponse) *AliasesUpdateNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases update not found response
func (o *AliasesUpdateNotFound) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesUpdateNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesUpdateUnprocessableEntityCode is the HTTP code returned for type AliasesUpdateUnprocessableEntity
const AliasesUpdateUnprocessableEntityCode int = 422

/*
AliasesUpdateUnprocessableEntity Invalid update alias request.

swagger:response aliasesUpdateUnprocessableEntity
*/
type AliasesUpdateUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesUpdateUnprocessableEntity creates AliasesUpdateUnprocessableEntity with default headers values
func NewAliasesUpdateUnprocessableEntity() *AliasesUpdateUnprocessableEntity {

	return &AliasesUpdateUnprocessableEntity{}
}

// WithPayload adds the payload to the aliases update unprocessable entity response
func (o *AliasesUpdateUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *AliasesUpdateUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases update unprocessable entity response
func (o *AliasesUpdateUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesUpdateUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// AliasesUpdateInternalServerErrorCode is the HTTP code returned for type AliasesUpdateInternalServerError
const AliasesUpdateInternalServerErrorCode int = 500

/*
AliasesUpdateInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response aliasesUpdateInternalServerError
*/
type AliasesUpdateInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewAliasesUpdateInternalServerError creates AliasesUpdateInternalServerError with default headers values
func NewAliasesUpdateInternalServerError() *AliasesUpdateInternalServerError {

	return &AliasesUpdateInternalServerError{}
}

// WithPayload adds the payload to the aliases update internal server error response
func (o *AliasesUpdateInternalServerError) WithPayload(payload *models.ErrorResponse) *AliasesUpdateInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the aliases update internal server error response
func (o *AliasesUpdateInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *AliasesUpdateInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
