//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"net/http"

	"github.com/go-openapi/runtime/middleware"

	"github.com/weaviate/weaviate/entities/models"
)

// SchemaObjectsShardsUpdateHandlerFunc turns a function with the right signature into a schema objects shards update handler
type SchemaObjectsShardsUpdateHandlerFunc func(SchemaObjectsShardsUpdateParams, *models.Principal) middleware.Responder

// Handle executing the request and returning a response
func (fn SchemaObjectsShardsUpdateHandlerFunc) Handle(params SchemaObjectsShardsUpdateParams, principal *models.Principal) middleware.Responder {
	return fn(params, principal)
}

// SchemaObjectsShardsUpdateHandler interface for that can handle valid schema objects shards update params
type SchemaObjectsShardsUpdateHandler interface {
	Handle(SchemaObjectsShardsUpdateParams, *models.Principal) middleware.Responder
}

// NewSchemaObjectsShardsUpdate creates a new http.Handler for the schema objects shards update operation
func NewSchemaObjectsShardsUpdate(ctx *middleware.Context, handler SchemaObjectsShardsUpdateHandler) *SchemaObjectsShardsUpdate {
	return &SchemaObjectsShardsUpdate{Context: ctx, Handler: handler}
}

/*
	SchemaObjectsShardsUpdate swagger:route PUT /schema/{className}/shards/{shardName} schema schemaObjectsShardsUpdate

# Update a shard status

Updates the status of a specific shard within a collection (e.g., sets it to `READY` or `READONLY`). This is typically used after resolving an underlying issue (like disk space) that caused a shard to become non-operational. There is also a convenience function in each client to set the status of all shards of a collection.
*/
type SchemaObjectsShardsUpdate struct {
	Context *middleware.Context
	Handler SchemaObjectsShardsUpdateHandler
}

func (o *SchemaObjectsShardsUpdate) ServeHTTP(rw http.ResponseWriter, r *http.Request) {
	route, rCtx, _ := o.Context.RouteInfo(r)
	if rCtx != nil {
		*r = *rCtx
	}
	var Params = NewSchemaObjectsShardsUpdateParams()
	uprinc, aCtx, err := o.Context.Authorize(r, route)
	if err != nil {
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}
	if aCtx != nil {
		*r = *aCtx
	}
	var principal *models.Principal
	if uprinc != nil {
		principal = uprinc.(*models.Principal) // this is really a models.Principal, I promise
	}

	if err := o.Context.BindValidRequest(r, route, &Params); err != nil { // bind params
		o.Context.Respond(rw, r, route.Produces, route, err)
		return
	}

	res := o.Handler.Handle(Params, principal) // actually handle the request
	o.Context.Respond(rw, r, route.Produces, route, res)

}
