//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// CreateUserCreatedCode is the HTTP code returned for type CreateUserCreated
const CreateUserCreatedCode int = 201

/*
CreateUserCreated User created successfully and API key returned.

swagger:response createUserCreated
*/
type CreateUserCreated struct {

	/*
	  In: Body
	*/
	Payload *models.UserAPIKey `json:"body,omitempty"`
}

// NewCreateUserCreated creates CreateUserCreated with default headers values
func NewCreateUserCreated() *CreateUserCreated {

	return &CreateUserCreated{}
}

// WithPayload adds the payload to the create user created response
func (o *CreateUserCreated) WithPayload(payload *models.UserAPIKey) *CreateUserCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create user created response
func (o *CreateUserCreated) SetPayload(payload *models.UserAPIKey) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateUserCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateUserBadRequestCode is the HTTP code returned for type CreateUserBadRequest
const CreateUserBadRequestCode int = 400

/*
CreateUserBadRequest Malformed request.

swagger:response createUserBadRequest
*/
type CreateUserBadRequest struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCreateUserBadRequest creates CreateUserBadRequest with default headers values
func NewCreateUserBadRequest() *CreateUserBadRequest {

	return &CreateUserBadRequest{}
}

// WithPayload adds the payload to the create user bad request response
func (o *CreateUserBadRequest) WithPayload(payload *models.ErrorResponse) *CreateUserBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create user bad request response
func (o *CreateUserBadRequest) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateUserBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateUserUnauthorizedCode is the HTTP code returned for type CreateUserUnauthorized
const CreateUserUnauthorizedCode int = 401

/*
CreateUserUnauthorized Unauthorized or invalid credentials.

swagger:response createUserUnauthorized
*/
type CreateUserUnauthorized struct {
}

// NewCreateUserUnauthorized creates CreateUserUnauthorized with default headers values
func NewCreateUserUnauthorized() *CreateUserUnauthorized {

	return &CreateUserUnauthorized{}
}

// WriteResponse to the client
func (o *CreateUserUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// CreateUserForbiddenCode is the HTTP code returned for type CreateUserForbidden
const CreateUserForbiddenCode int = 403

/*
CreateUserForbidden Forbidden

swagger:response createUserForbidden
*/
type CreateUserForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCreateUserForbidden creates CreateUserForbidden with default headers values
func NewCreateUserForbidden() *CreateUserForbidden {

	return &CreateUserForbidden{}
}

// WithPayload adds the payload to the create user forbidden response
func (o *CreateUserForbidden) WithPayload(payload *models.ErrorResponse) *CreateUserForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create user forbidden response
func (o *CreateUserForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateUserForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateUserNotFoundCode is the HTTP code returned for type CreateUserNotFound
const CreateUserNotFoundCode int = 404

/*
CreateUserNotFound User not found.

swagger:response createUserNotFound
*/
type CreateUserNotFound struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCreateUserNotFound creates CreateUserNotFound with default headers values
func NewCreateUserNotFound() *CreateUserNotFound {

	return &CreateUserNotFound{}
}

// WithPayload adds the payload to the create user not found response
func (o *CreateUserNotFound) WithPayload(payload *models.ErrorResponse) *CreateUserNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create user not found response
func (o *CreateUserNotFound) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateUserNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateUserConflictCode is the HTTP code returned for type CreateUserConflict
const CreateUserConflictCode int = 409

/*
CreateUserConflict A user with the specified name already exists.

swagger:response createUserConflict
*/
type CreateUserConflict struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCreateUserConflict creates CreateUserConflict with default headers values
func NewCreateUserConflict() *CreateUserConflict {

	return &CreateUserConflict{}
}

// WithPayload adds the payload to the create user conflict response
func (o *CreateUserConflict) WithPayload(payload *models.ErrorResponse) *CreateUserConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create user conflict response
func (o *CreateUserConflict) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateUserConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateUserUnprocessableEntityCode is the HTTP code returned for type CreateUserUnprocessableEntity
const CreateUserUnprocessableEntityCode int = 422

/*
CreateUserUnprocessableEntity The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.

swagger:response createUserUnprocessableEntity
*/
type CreateUserUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCreateUserUnprocessableEntity creates CreateUserUnprocessableEntity with default headers values
func NewCreateUserUnprocessableEntity() *CreateUserUnprocessableEntity {

	return &CreateUserUnprocessableEntity{}
}

// WithPayload adds the payload to the create user unprocessable entity response
func (o *CreateUserUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *CreateUserUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create user unprocessable entity response
func (o *CreateUserUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateUserUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateUserInternalServerErrorCode is the HTTP code returned for type CreateUserInternalServerError
const CreateUserInternalServerErrorCode int = 500

/*
CreateUserInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response createUserInternalServerError
*/
type CreateUserInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewCreateUserInternalServerError creates CreateUserInternalServerError with default headers values
func NewCreateUserInternalServerError() *CreateUserInternalServerError {

	return &CreateUserInternalServerError{}
}

// WithPayload adds the payload to the create user internal server error response
func (o *CreateUserInternalServerError) WithPayload(payload *models.ErrorResponse) *CreateUserInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create user internal server error response
func (o *CreateUserInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateUserInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
