//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/weaviate/weaviate/entities/models"
)

// GetUserInfoOKCode is the HTTP code returned for type GetUserInfoOK
const GetUserInfoOKCode int = 200

/*
GetUserInfoOK Info about the user.

swagger:response getUserInfoOK
*/
type GetUserInfoOK struct {

	/*
	  In: Body
	*/
	Payload *models.DBUserInfo `json:"body,omitempty"`
}

// NewGetUserInfoOK creates GetUserInfoOK with default headers values
func NewGetUserInfoOK() *GetUserInfoOK {

	return &GetUserInfoOK{}
}

// WithPayload adds the payload to the get user info o k response
func (o *GetUserInfoOK) WithPayload(payload *models.DBUserInfo) *GetUserInfoOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get user info o k response
func (o *GetUserInfoOK) SetPayload(payload *models.DBUserInfo) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetUserInfoOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetUserInfoUnauthorizedCode is the HTTP code returned for type GetUserInfoUnauthorized
const GetUserInfoUnauthorizedCode int = 401

/*
GetUserInfoUnauthorized Unauthorized or invalid credentials.

swagger:response getUserInfoUnauthorized
*/
type GetUserInfoUnauthorized struct {
}

// NewGetUserInfoUnauthorized creates GetUserInfoUnauthorized with default headers values
func NewGetUserInfoUnauthorized() *GetUserInfoUnauthorized {

	return &GetUserInfoUnauthorized{}
}

// WriteResponse to the client
func (o *GetUserInfoUnauthorized) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(401)
}

// GetUserInfoForbiddenCode is the HTTP code returned for type GetUserInfoForbidden
const GetUserInfoForbiddenCode int = 403

/*
GetUserInfoForbidden Forbidden

swagger:response getUserInfoForbidden
*/
type GetUserInfoForbidden struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetUserInfoForbidden creates GetUserInfoForbidden with default headers values
func NewGetUserInfoForbidden() *GetUserInfoForbidden {

	return &GetUserInfoForbidden{}
}

// WithPayload adds the payload to the get user info forbidden response
func (o *GetUserInfoForbidden) WithPayload(payload *models.ErrorResponse) *GetUserInfoForbidden {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get user info forbidden response
func (o *GetUserInfoForbidden) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetUserInfoForbidden) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(403)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetUserInfoNotFoundCode is the HTTP code returned for type GetUserInfoNotFound
const GetUserInfoNotFoundCode int = 404

/*
GetUserInfoNotFound User not found.

swagger:response getUserInfoNotFound
*/
type GetUserInfoNotFound struct {
}

// NewGetUserInfoNotFound creates GetUserInfoNotFound with default headers values
func NewGetUserInfoNotFound() *GetUserInfoNotFound {

	return &GetUserInfoNotFound{}
}

// WriteResponse to the client
func (o *GetUserInfoNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

// GetUserInfoUnprocessableEntityCode is the HTTP code returned for type GetUserInfoUnprocessableEntity
const GetUserInfoUnprocessableEntityCode int = 422

/*
GetUserInfoUnprocessableEntity The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.

swagger:response getUserInfoUnprocessableEntity
*/
type GetUserInfoUnprocessableEntity struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetUserInfoUnprocessableEntity creates GetUserInfoUnprocessableEntity with default headers values
func NewGetUserInfoUnprocessableEntity() *GetUserInfoUnprocessableEntity {

	return &GetUserInfoUnprocessableEntity{}
}

// WithPayload adds the payload to the get user info unprocessable entity response
func (o *GetUserInfoUnprocessableEntity) WithPayload(payload *models.ErrorResponse) *GetUserInfoUnprocessableEntity {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get user info unprocessable entity response
func (o *GetUserInfoUnprocessableEntity) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetUserInfoUnprocessableEntity) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(422)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetUserInfoInternalServerErrorCode is the HTTP code returned for type GetUserInfoInternalServerError
const GetUserInfoInternalServerErrorCode int = 500

/*
GetUserInfoInternalServerError An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.

swagger:response getUserInfoInternalServerError
*/
type GetUserInfoInternalServerError struct {

	/*
	  In: Body
	*/
	Payload *models.ErrorResponse `json:"body,omitempty"`
}

// NewGetUserInfoInternalServerError creates GetUserInfoInternalServerError with default headers values
func NewGetUserInfoInternalServerError() *GetUserInfoInternalServerError {

	return &GetUserInfoInternalServerError{}
}

// WithPayload adds the payload to the get user info internal server error response
func (o *GetUserInfoInternalServerError) WithPayload(payload *models.ErrorResponse) *GetUserInfoInternalServerError {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get user info internal server error response
func (o *GetUserInfoInternalServerError) SetPayload(payload *models.ErrorResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetUserInfoInternalServerError) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(500)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
