//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// GetGroupsReader is a Reader for the GetGroups structure.
type GetGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetGroupsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetGroupsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewGetGroupsUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetGroupsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetGroupsOK creates a GetGroupsOK with default headers values
func NewGetGroupsOK() *GetGroupsOK {
	return &GetGroupsOK{}
}

/*
GetGroupsOK describes a response with status code 200, with default header values.

A list of group names for the specified type.
*/
type GetGroupsOK struct {
	Payload []string
}

// IsSuccess returns true when this get groups o k response has a 2xx status code
func (o *GetGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get groups o k response has a 3xx status code
func (o *GetGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups o k response has a 4xx status code
func (o *GetGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get groups o k response has a 5xx status code
func (o *GetGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get groups o k response a status code equal to that given
func (o *GetGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get groups o k response
func (o *GetGroupsOK) Code() int {
	return 200
}

func (o *GetGroupsOK) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsOK  %+v", 200, o.Payload)
}

func (o *GetGroupsOK) String() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsOK  %+v", 200, o.Payload)
}

func (o *GetGroupsOK) GetPayload() []string {
	return o.Payload
}

func (o *GetGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupsBadRequest creates a GetGroupsBadRequest with default headers values
func NewGetGroupsBadRequest() *GetGroupsBadRequest {
	return &GetGroupsBadRequest{}
}

/*
GetGroupsBadRequest describes a response with status code 400, with default header values.

Bad request
*/
type GetGroupsBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get groups bad request response has a 2xx status code
func (o *GetGroupsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get groups bad request response has a 3xx status code
func (o *GetGroupsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups bad request response has a 4xx status code
func (o *GetGroupsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get groups bad request response has a 5xx status code
func (o *GetGroupsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get groups bad request response a status code equal to that given
func (o *GetGroupsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get groups bad request response
func (o *GetGroupsBadRequest) Code() int {
	return 400
}

func (o *GetGroupsBadRequest) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *GetGroupsBadRequest) String() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsBadRequest  %+v", 400, o.Payload)
}

func (o *GetGroupsBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetGroupsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupsUnauthorized creates a GetGroupsUnauthorized with default headers values
func NewGetGroupsUnauthorized() *GetGroupsUnauthorized {
	return &GetGroupsUnauthorized{}
}

/*
GetGroupsUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type GetGroupsUnauthorized struct {
}

// IsSuccess returns true when this get groups unauthorized response has a 2xx status code
func (o *GetGroupsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get groups unauthorized response has a 3xx status code
func (o *GetGroupsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups unauthorized response has a 4xx status code
func (o *GetGroupsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get groups unauthorized response has a 5xx status code
func (o *GetGroupsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get groups unauthorized response a status code equal to that given
func (o *GetGroupsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get groups unauthorized response
func (o *GetGroupsUnauthorized) Code() int {
	return 401
}

func (o *GetGroupsUnauthorized) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsUnauthorized ", 401)
}

func (o *GetGroupsUnauthorized) String() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsUnauthorized ", 401)
}

func (o *GetGroupsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetGroupsForbidden creates a GetGroupsForbidden with default headers values
func NewGetGroupsForbidden() *GetGroupsForbidden {
	return &GetGroupsForbidden{}
}

/*
GetGroupsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetGroupsForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get groups forbidden response has a 2xx status code
func (o *GetGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get groups forbidden response has a 3xx status code
func (o *GetGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups forbidden response has a 4xx status code
func (o *GetGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get groups forbidden response has a 5xx status code
func (o *GetGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get groups forbidden response a status code equal to that given
func (o *GetGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get groups forbidden response
func (o *GetGroupsForbidden) Code() int {
	return 403
}

func (o *GetGroupsForbidden) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsForbidden  %+v", 403, o.Payload)
}

func (o *GetGroupsForbidden) String() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsForbidden  %+v", 403, o.Payload)
}

func (o *GetGroupsForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupsUnprocessableEntity creates a GetGroupsUnprocessableEntity with default headers values
func NewGetGroupsUnprocessableEntity() *GetGroupsUnprocessableEntity {
	return &GetGroupsUnprocessableEntity{}
}

/*
GetGroupsUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.
*/
type GetGroupsUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get groups unprocessable entity response has a 2xx status code
func (o *GetGroupsUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get groups unprocessable entity response has a 3xx status code
func (o *GetGroupsUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups unprocessable entity response has a 4xx status code
func (o *GetGroupsUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this get groups unprocessable entity response has a 5xx status code
func (o *GetGroupsUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this get groups unprocessable entity response a status code equal to that given
func (o *GetGroupsUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the get groups unprocessable entity response
func (o *GetGroupsUnprocessableEntity) Code() int {
	return 422
}

func (o *GetGroupsUnprocessableEntity) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *GetGroupsUnprocessableEntity) String() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *GetGroupsUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetGroupsUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupsInternalServerError creates a GetGroupsInternalServerError with default headers values
func NewGetGroupsInternalServerError() *GetGroupsInternalServerError {
	return &GetGroupsInternalServerError{}
}

/*
GetGroupsInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type GetGroupsInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get groups internal server error response has a 2xx status code
func (o *GetGroupsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get groups internal server error response has a 3xx status code
func (o *GetGroupsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get groups internal server error response has a 4xx status code
func (o *GetGroupsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get groups internal server error response has a 5xx status code
func (o *GetGroupsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get groups internal server error response a status code equal to that given
func (o *GetGroupsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get groups internal server error response
func (o *GetGroupsInternalServerError) Code() int {
	return 500
}

func (o *GetGroupsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetGroupsInternalServerError) String() string {
	return fmt.Sprintf("[GET /authz/groups/{groupType}][%d] getGroupsInternalServerError  %+v", 500, o.Payload)
}

func (o *GetGroupsInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetGroupsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
