//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/weaviate/weaviate/entities/models"
)

// GetUsersForRoleReader is a Reader for the GetUsersForRole structure.
type GetUsersForRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetUsersForRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetUsersForRoleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetUsersForRoleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetUsersForRoleUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetUsersForRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetUsersForRoleNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetUsersForRoleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetUsersForRoleOK creates a GetUsersForRoleOK with default headers values
func NewGetUsersForRoleOK() *GetUsersForRoleOK {
	return &GetUsersForRoleOK{}
}

/*
GetUsersForRoleOK describes a response with status code 200, with default header values.

Users assigned to this role.
*/
type GetUsersForRoleOK struct {
	Payload []*GetUsersForRoleOKBodyItems0
}

// IsSuccess returns true when this get users for role o k response has a 2xx status code
func (o *GetUsersForRoleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get users for role o k response has a 3xx status code
func (o *GetUsersForRoleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get users for role o k response has a 4xx status code
func (o *GetUsersForRoleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get users for role o k response has a 5xx status code
func (o *GetUsersForRoleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get users for role o k response a status code equal to that given
func (o *GetUsersForRoleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get users for role o k response
func (o *GetUsersForRoleOK) Code() int {
	return 200
}

func (o *GetUsersForRoleOK) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleOK  %+v", 200, o.Payload)
}

func (o *GetUsersForRoleOK) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleOK  %+v", 200, o.Payload)
}

func (o *GetUsersForRoleOK) GetPayload() []*GetUsersForRoleOKBodyItems0 {
	return o.Payload
}

func (o *GetUsersForRoleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUsersForRoleBadRequest creates a GetUsersForRoleBadRequest with default headers values
func NewGetUsersForRoleBadRequest() *GetUsersForRoleBadRequest {
	return &GetUsersForRoleBadRequest{}
}

/*
GetUsersForRoleBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type GetUsersForRoleBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get users for role bad request response has a 2xx status code
func (o *GetUsersForRoleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get users for role bad request response has a 3xx status code
func (o *GetUsersForRoleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get users for role bad request response has a 4xx status code
func (o *GetUsersForRoleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get users for role bad request response has a 5xx status code
func (o *GetUsersForRoleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get users for role bad request response a status code equal to that given
func (o *GetUsersForRoleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get users for role bad request response
func (o *GetUsersForRoleBadRequest) Code() int {
	return 400
}

func (o *GetUsersForRoleBadRequest) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleBadRequest  %+v", 400, o.Payload)
}

func (o *GetUsersForRoleBadRequest) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleBadRequest  %+v", 400, o.Payload)
}

func (o *GetUsersForRoleBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetUsersForRoleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUsersForRoleUnauthorized creates a GetUsersForRoleUnauthorized with default headers values
func NewGetUsersForRoleUnauthorized() *GetUsersForRoleUnauthorized {
	return &GetUsersForRoleUnauthorized{}
}

/*
GetUsersForRoleUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type GetUsersForRoleUnauthorized struct {
}

// IsSuccess returns true when this get users for role unauthorized response has a 2xx status code
func (o *GetUsersForRoleUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get users for role unauthorized response has a 3xx status code
func (o *GetUsersForRoleUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get users for role unauthorized response has a 4xx status code
func (o *GetUsersForRoleUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get users for role unauthorized response has a 5xx status code
func (o *GetUsersForRoleUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get users for role unauthorized response a status code equal to that given
func (o *GetUsersForRoleUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get users for role unauthorized response
func (o *GetUsersForRoleUnauthorized) Code() int {
	return 401
}

func (o *GetUsersForRoleUnauthorized) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleUnauthorized ", 401)
}

func (o *GetUsersForRoleUnauthorized) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleUnauthorized ", 401)
}

func (o *GetUsersForRoleUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetUsersForRoleForbidden creates a GetUsersForRoleForbidden with default headers values
func NewGetUsersForRoleForbidden() *GetUsersForRoleForbidden {
	return &GetUsersForRoleForbidden{}
}

/*
GetUsersForRoleForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetUsersForRoleForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get users for role forbidden response has a 2xx status code
func (o *GetUsersForRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get users for role forbidden response has a 3xx status code
func (o *GetUsersForRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get users for role forbidden response has a 4xx status code
func (o *GetUsersForRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get users for role forbidden response has a 5xx status code
func (o *GetUsersForRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get users for role forbidden response a status code equal to that given
func (o *GetUsersForRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get users for role forbidden response
func (o *GetUsersForRoleForbidden) Code() int {
	return 403
}

func (o *GetUsersForRoleForbidden) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleForbidden  %+v", 403, o.Payload)
}

func (o *GetUsersForRoleForbidden) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleForbidden  %+v", 403, o.Payload)
}

func (o *GetUsersForRoleForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetUsersForRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUsersForRoleNotFound creates a GetUsersForRoleNotFound with default headers values
func NewGetUsersForRoleNotFound() *GetUsersForRoleNotFound {
	return &GetUsersForRoleNotFound{}
}

/*
GetUsersForRoleNotFound describes a response with status code 404, with default header values.

No role found.
*/
type GetUsersForRoleNotFound struct {
}

// IsSuccess returns true when this get users for role not found response has a 2xx status code
func (o *GetUsersForRoleNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get users for role not found response has a 3xx status code
func (o *GetUsersForRoleNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get users for role not found response has a 4xx status code
func (o *GetUsersForRoleNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get users for role not found response has a 5xx status code
func (o *GetUsersForRoleNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get users for role not found response a status code equal to that given
func (o *GetUsersForRoleNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get users for role not found response
func (o *GetUsersForRoleNotFound) Code() int {
	return 404
}

func (o *GetUsersForRoleNotFound) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleNotFound ", 404)
}

func (o *GetUsersForRoleNotFound) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleNotFound ", 404)
}

func (o *GetUsersForRoleNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetUsersForRoleInternalServerError creates a GetUsersForRoleInternalServerError with default headers values
func NewGetUsersForRoleInternalServerError() *GetUsersForRoleInternalServerError {
	return &GetUsersForRoleInternalServerError{}
}

/*
GetUsersForRoleInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type GetUsersForRoleInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get users for role internal server error response has a 2xx status code
func (o *GetUsersForRoleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get users for role internal server error response has a 3xx status code
func (o *GetUsersForRoleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get users for role internal server error response has a 4xx status code
func (o *GetUsersForRoleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get users for role internal server error response has a 5xx status code
func (o *GetUsersForRoleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get users for role internal server error response a status code equal to that given
func (o *GetUsersForRoleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get users for role internal server error response
func (o *GetUsersForRoleInternalServerError) Code() int {
	return 500
}

func (o *GetUsersForRoleInternalServerError) Error() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *GetUsersForRoleInternalServerError) String() string {
	return fmt.Sprintf("[GET /authz/roles/{id}/user-assignments][%d] getUsersForRoleInternalServerError  %+v", 500, o.Payload)
}

func (o *GetUsersForRoleInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetUsersForRoleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GetUsersForRoleOKBodyItems0 get users for role o k body items0
swagger:model GetUsersForRoleOKBodyItems0
*/
type GetUsersForRoleOKBodyItems0 struct {

	// user Id
	UserID string `json:"userId,omitempty"`

	// user type
	// Required: true
	UserType *models.UserTypeOutput `json:"userType"`
}

// Validate validates this get users for role o k body items0
func (o *GetUsersForRoleOKBodyItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUserType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetUsersForRoleOKBodyItems0) validateUserType(formats strfmt.Registry) error {

	if err := validate.Required("userType", "body", o.UserType); err != nil {
		return err
	}

	if err := validate.Required("userType", "body", o.UserType); err != nil {
		return err
	}

	if o.UserType != nil {
		if err := o.UserType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("userType")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("userType")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this get users for role o k body items0 based on the context it is used
func (o *GetUsersForRoleOKBodyItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUserType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *GetUsersForRoleOKBodyItems0) contextValidateUserType(ctx context.Context, formats strfmt.Registry) error {

	if o.UserType != nil {
		if err := o.UserType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("userType")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("userType")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *GetUsersForRoleOKBodyItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetUsersForRoleOKBodyItems0) UnmarshalBinary(b []byte) error {
	var res GetUsersForRoleOKBodyItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
