//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package authz

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewRevokeRoleFromUserParams creates a new RevokeRoleFromUserParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRevokeRoleFromUserParams() *RevokeRoleFromUserParams {
	return &RevokeRoleFromUserParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRevokeRoleFromUserParamsWithTimeout creates a new RevokeRoleFromUserParams object
// with the ability to set a timeout on a request.
func NewRevokeRoleFromUserParamsWithTimeout(timeout time.Duration) *RevokeRoleFromUserParams {
	return &RevokeRoleFromUserParams{
		timeout: timeout,
	}
}

// NewRevokeRoleFromUserParamsWithContext creates a new RevokeRoleFromUserParams object
// with the ability to set a context for a request.
func NewRevokeRoleFromUserParamsWithContext(ctx context.Context) *RevokeRoleFromUserParams {
	return &RevokeRoleFromUserParams{
		Context: ctx,
	}
}

// NewRevokeRoleFromUserParamsWithHTTPClient creates a new RevokeRoleFromUserParams object
// with the ability to set a custom HTTPClient for a request.
func NewRevokeRoleFromUserParamsWithHTTPClient(client *http.Client) *RevokeRoleFromUserParams {
	return &RevokeRoleFromUserParams{
		HTTPClient: client,
	}
}

/*
RevokeRoleFromUserParams contains all the parameters to send to the API endpoint

	for the revoke role from user operation.

	Typically these are written to a http.Request.
*/
type RevokeRoleFromUserParams struct {

	// Body.
	Body RevokeRoleFromUserBody

	/* ID.

	   The name of the user.
	*/
	ID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the revoke role from user params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RevokeRoleFromUserParams) WithDefaults() *RevokeRoleFromUserParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the revoke role from user params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RevokeRoleFromUserParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the revoke role from user params
func (o *RevokeRoleFromUserParams) WithTimeout(timeout time.Duration) *RevokeRoleFromUserParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the revoke role from user params
func (o *RevokeRoleFromUserParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the revoke role from user params
func (o *RevokeRoleFromUserParams) WithContext(ctx context.Context) *RevokeRoleFromUserParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the revoke role from user params
func (o *RevokeRoleFromUserParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the revoke role from user params
func (o *RevokeRoleFromUserParams) WithHTTPClient(client *http.Client) *RevokeRoleFromUserParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the revoke role from user params
func (o *RevokeRoleFromUserParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the revoke role from user params
func (o *RevokeRoleFromUserParams) WithBody(body RevokeRoleFromUserBody) *RevokeRoleFromUserParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the revoke role from user params
func (o *RevokeRoleFromUserParams) SetBody(body RevokeRoleFromUserBody) {
	o.Body = body
}

// WithID adds the id to the revoke role from user params
func (o *RevokeRoleFromUserParams) WithID(id string) *RevokeRoleFromUserParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the revoke role from user params
func (o *RevokeRoleFromUserParams) SetID(id string) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *RevokeRoleFromUserParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
