//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package backups

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewBackupsCancelParams creates a new BackupsCancelParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBackupsCancelParams() *BackupsCancelParams {
	return &BackupsCancelParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBackupsCancelParamsWithTimeout creates a new BackupsCancelParams object
// with the ability to set a timeout on a request.
func NewBackupsCancelParamsWithTimeout(timeout time.Duration) *BackupsCancelParams {
	return &BackupsCancelParams{
		timeout: timeout,
	}
}

// NewBackupsCancelParamsWithContext creates a new BackupsCancelParams object
// with the ability to set a context for a request.
func NewBackupsCancelParamsWithContext(ctx context.Context) *BackupsCancelParams {
	return &BackupsCancelParams{
		Context: ctx,
	}
}

// NewBackupsCancelParamsWithHTTPClient creates a new BackupsCancelParams object
// with the ability to set a custom HTTPClient for a request.
func NewBackupsCancelParamsWithHTTPClient(client *http.Client) *BackupsCancelParams {
	return &BackupsCancelParams{
		HTTPClient: client,
	}
}

/*
BackupsCancelParams contains all the parameters to send to the API endpoint

	for the backups cancel operation.

	Typically these are written to a http.Request.
*/
type BackupsCancelParams struct {

	/* Backend.

	   Specifies the backend storage system where the backup resides (e.g., `filesystem`, `gcs`, `s3`, `azure`).
	*/
	Backend string

	/* Bucket.

	   Optional: Specifies the bucket, container, or volume name if required by the backend.
	*/
	Bucket *string

	/* ID.

	   The unique identifier of the backup to cancel. Must be URL-safe and compatible with filesystem paths (only lowercase, numbers, underscore, minus characters allowed).
	*/
	ID string

	/* Path.

	   Optional: Specifies the path within the bucket/container/volume if the backup is not at the root.
	*/
	Path *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the backups cancel params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BackupsCancelParams) WithDefaults() *BackupsCancelParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the backups cancel params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BackupsCancelParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the backups cancel params
func (o *BackupsCancelParams) WithTimeout(timeout time.Duration) *BackupsCancelParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the backups cancel params
func (o *BackupsCancelParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the backups cancel params
func (o *BackupsCancelParams) WithContext(ctx context.Context) *BackupsCancelParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the backups cancel params
func (o *BackupsCancelParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the backups cancel params
func (o *BackupsCancelParams) WithHTTPClient(client *http.Client) *BackupsCancelParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the backups cancel params
func (o *BackupsCancelParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBackend adds the backend to the backups cancel params
func (o *BackupsCancelParams) WithBackend(backend string) *BackupsCancelParams {
	o.SetBackend(backend)
	return o
}

// SetBackend adds the backend to the backups cancel params
func (o *BackupsCancelParams) SetBackend(backend string) {
	o.Backend = backend
}

// WithBucket adds the bucket to the backups cancel params
func (o *BackupsCancelParams) WithBucket(bucket *string) *BackupsCancelParams {
	o.SetBucket(bucket)
	return o
}

// SetBucket adds the bucket to the backups cancel params
func (o *BackupsCancelParams) SetBucket(bucket *string) {
	o.Bucket = bucket
}

// WithID adds the id to the backups cancel params
func (o *BackupsCancelParams) WithID(id string) *BackupsCancelParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the backups cancel params
func (o *BackupsCancelParams) SetID(id string) {
	o.ID = id
}

// WithPath adds the path to the backups cancel params
func (o *BackupsCancelParams) WithPath(path *string) *BackupsCancelParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the backups cancel params
func (o *BackupsCancelParams) SetPath(path *string) {
	o.Path = path
}

// WriteToRequest writes these params to a swagger request
func (o *BackupsCancelParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param backend
	if err := r.SetPathParam("backend", o.Backend); err != nil {
		return err
	}

	if o.Bucket != nil {

		// query param bucket
		var qrBucket string

		if o.Bucket != nil {
			qrBucket = *o.Bucket
		}
		qBucket := qrBucket
		if qBucket != "" {

			if err := r.SetQueryParam("bucket", qBucket); err != nil {
				return err
			}
		}
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if o.Path != nil {

		// query param path
		var qrPath string

		if o.Path != nil {
			qrPath = *o.Path
		}
		qPath := qrPath
		if qPath != "" {

			if err := r.SetQueryParam("path", qPath); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
