//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package backups

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// BackupsListReader is a Reader for the BackupsList structure.
type BackupsListReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BackupsListReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBackupsListOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewBackupsListUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewBackupsListForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewBackupsListUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewBackupsListInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewBackupsListOK creates a BackupsListOK with default headers values
func NewBackupsListOK() *BackupsListOK {
	return &BackupsListOK{}
}

/*
BackupsListOK describes a response with status code 200, with default header values.

Successfully retrieved the list of backups in progress.
*/
type BackupsListOK struct {
	Payload models.BackupListResponse
}

// IsSuccess returns true when this backups list o k response has a 2xx status code
func (o *BackupsListOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this backups list o k response has a 3xx status code
func (o *BackupsListOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this backups list o k response has a 4xx status code
func (o *BackupsListOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this backups list o k response has a 5xx status code
func (o *BackupsListOK) IsServerError() bool {
	return false
}

// IsCode returns true when this backups list o k response a status code equal to that given
func (o *BackupsListOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the backups list o k response
func (o *BackupsListOK) Code() int {
	return 200
}

func (o *BackupsListOK) Error() string {
	return fmt.Sprintf("[GET /backups/{backend}][%d] backupsListOK  %+v", 200, o.Payload)
}

func (o *BackupsListOK) String() string {
	return fmt.Sprintf("[GET /backups/{backend}][%d] backupsListOK  %+v", 200, o.Payload)
}

func (o *BackupsListOK) GetPayload() models.BackupListResponse {
	return o.Payload
}

func (o *BackupsListOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBackupsListUnauthorized creates a BackupsListUnauthorized with default headers values
func NewBackupsListUnauthorized() *BackupsListUnauthorized {
	return &BackupsListUnauthorized{}
}

/*
BackupsListUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type BackupsListUnauthorized struct {
}

// IsSuccess returns true when this backups list unauthorized response has a 2xx status code
func (o *BackupsListUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this backups list unauthorized response has a 3xx status code
func (o *BackupsListUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this backups list unauthorized response has a 4xx status code
func (o *BackupsListUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this backups list unauthorized response has a 5xx status code
func (o *BackupsListUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this backups list unauthorized response a status code equal to that given
func (o *BackupsListUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the backups list unauthorized response
func (o *BackupsListUnauthorized) Code() int {
	return 401
}

func (o *BackupsListUnauthorized) Error() string {
	return fmt.Sprintf("[GET /backups/{backend}][%d] backupsListUnauthorized ", 401)
}

func (o *BackupsListUnauthorized) String() string {
	return fmt.Sprintf("[GET /backups/{backend}][%d] backupsListUnauthorized ", 401)
}

func (o *BackupsListUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewBackupsListForbidden creates a BackupsListForbidden with default headers values
func NewBackupsListForbidden() *BackupsListForbidden {
	return &BackupsListForbidden{}
}

/*
BackupsListForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type BackupsListForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this backups list forbidden response has a 2xx status code
func (o *BackupsListForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this backups list forbidden response has a 3xx status code
func (o *BackupsListForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this backups list forbidden response has a 4xx status code
func (o *BackupsListForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this backups list forbidden response has a 5xx status code
func (o *BackupsListForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this backups list forbidden response a status code equal to that given
func (o *BackupsListForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the backups list forbidden response
func (o *BackupsListForbidden) Code() int {
	return 403
}

func (o *BackupsListForbidden) Error() string {
	return fmt.Sprintf("[GET /backups/{backend}][%d] backupsListForbidden  %+v", 403, o.Payload)
}

func (o *BackupsListForbidden) String() string {
	return fmt.Sprintf("[GET /backups/{backend}][%d] backupsListForbidden  %+v", 403, o.Payload)
}

func (o *BackupsListForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BackupsListForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBackupsListUnprocessableEntity creates a BackupsListUnprocessableEntity with default headers values
func NewBackupsListUnprocessableEntity() *BackupsListUnprocessableEntity {
	return &BackupsListUnprocessableEntity{}
}

/*
BackupsListUnprocessableEntity describes a response with status code 422, with default header values.

Invalid request to list backups.
*/
type BackupsListUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this backups list unprocessable entity response has a 2xx status code
func (o *BackupsListUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this backups list unprocessable entity response has a 3xx status code
func (o *BackupsListUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this backups list unprocessable entity response has a 4xx status code
func (o *BackupsListUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this backups list unprocessable entity response has a 5xx status code
func (o *BackupsListUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this backups list unprocessable entity response a status code equal to that given
func (o *BackupsListUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the backups list unprocessable entity response
func (o *BackupsListUnprocessableEntity) Code() int {
	return 422
}

func (o *BackupsListUnprocessableEntity) Error() string {
	return fmt.Sprintf("[GET /backups/{backend}][%d] backupsListUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *BackupsListUnprocessableEntity) String() string {
	return fmt.Sprintf("[GET /backups/{backend}][%d] backupsListUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *BackupsListUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BackupsListUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBackupsListInternalServerError creates a BackupsListInternalServerError with default headers values
func NewBackupsListInternalServerError() *BackupsListInternalServerError {
	return &BackupsListInternalServerError{}
}

/*
BackupsListInternalServerError describes a response with status code 500, with default header values.

An internal server error occurred while listing backups. Check the ErrorResponse for details.
*/
type BackupsListInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this backups list internal server error response has a 2xx status code
func (o *BackupsListInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this backups list internal server error response has a 3xx status code
func (o *BackupsListInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this backups list internal server error response has a 4xx status code
func (o *BackupsListInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this backups list internal server error response has a 5xx status code
func (o *BackupsListInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this backups list internal server error response a status code equal to that given
func (o *BackupsListInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the backups list internal server error response
func (o *BackupsListInternalServerError) Code() int {
	return 500
}

func (o *BackupsListInternalServerError) Error() string {
	return fmt.Sprintf("[GET /backups/{backend}][%d] backupsListInternalServerError  %+v", 500, o.Payload)
}

func (o *BackupsListInternalServerError) String() string {
	return fmt.Sprintf("[GET /backups/{backend}][%d] backupsListInternalServerError  %+v", 500, o.Payload)
}

func (o *BackupsListInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BackupsListInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
