//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package backups

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// BackupsRestoreStatusReader is a Reader for the BackupsRestoreStatus structure.
type BackupsRestoreStatusReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BackupsRestoreStatusReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBackupsRestoreStatusOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewBackupsRestoreStatusUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewBackupsRestoreStatusForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewBackupsRestoreStatusNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewBackupsRestoreStatusInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewBackupsRestoreStatusOK creates a BackupsRestoreStatusOK with default headers values
func NewBackupsRestoreStatusOK() *BackupsRestoreStatusOK {
	return &BackupsRestoreStatusOK{}
}

/*
BackupsRestoreStatusOK describes a response with status code 200, with default header values.

Successfully retrieved the status of the backup restoration process.
*/
type BackupsRestoreStatusOK struct {
	Payload *models.BackupRestoreStatusResponse
}

// IsSuccess returns true when this backups restore status o k response has a 2xx status code
func (o *BackupsRestoreStatusOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this backups restore status o k response has a 3xx status code
func (o *BackupsRestoreStatusOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this backups restore status o k response has a 4xx status code
func (o *BackupsRestoreStatusOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this backups restore status o k response has a 5xx status code
func (o *BackupsRestoreStatusOK) IsServerError() bool {
	return false
}

// IsCode returns true when this backups restore status o k response a status code equal to that given
func (o *BackupsRestoreStatusOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the backups restore status o k response
func (o *BackupsRestoreStatusOK) Code() int {
	return 200
}

func (o *BackupsRestoreStatusOK) Error() string {
	return fmt.Sprintf("[GET /backups/{backend}/{id}/restore][%d] backupsRestoreStatusOK  %+v", 200, o.Payload)
}

func (o *BackupsRestoreStatusOK) String() string {
	return fmt.Sprintf("[GET /backups/{backend}/{id}/restore][%d] backupsRestoreStatusOK  %+v", 200, o.Payload)
}

func (o *BackupsRestoreStatusOK) GetPayload() *models.BackupRestoreStatusResponse {
	return o.Payload
}

func (o *BackupsRestoreStatusOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.BackupRestoreStatusResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBackupsRestoreStatusUnauthorized creates a BackupsRestoreStatusUnauthorized with default headers values
func NewBackupsRestoreStatusUnauthorized() *BackupsRestoreStatusUnauthorized {
	return &BackupsRestoreStatusUnauthorized{}
}

/*
BackupsRestoreStatusUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type BackupsRestoreStatusUnauthorized struct {
}

// IsSuccess returns true when this backups restore status unauthorized response has a 2xx status code
func (o *BackupsRestoreStatusUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this backups restore status unauthorized response has a 3xx status code
func (o *BackupsRestoreStatusUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this backups restore status unauthorized response has a 4xx status code
func (o *BackupsRestoreStatusUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this backups restore status unauthorized response has a 5xx status code
func (o *BackupsRestoreStatusUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this backups restore status unauthorized response a status code equal to that given
func (o *BackupsRestoreStatusUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the backups restore status unauthorized response
func (o *BackupsRestoreStatusUnauthorized) Code() int {
	return 401
}

func (o *BackupsRestoreStatusUnauthorized) Error() string {
	return fmt.Sprintf("[GET /backups/{backend}/{id}/restore][%d] backupsRestoreStatusUnauthorized ", 401)
}

func (o *BackupsRestoreStatusUnauthorized) String() string {
	return fmt.Sprintf("[GET /backups/{backend}/{id}/restore][%d] backupsRestoreStatusUnauthorized ", 401)
}

func (o *BackupsRestoreStatusUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewBackupsRestoreStatusForbidden creates a BackupsRestoreStatusForbidden with default headers values
func NewBackupsRestoreStatusForbidden() *BackupsRestoreStatusForbidden {
	return &BackupsRestoreStatusForbidden{}
}

/*
BackupsRestoreStatusForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type BackupsRestoreStatusForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this backups restore status forbidden response has a 2xx status code
func (o *BackupsRestoreStatusForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this backups restore status forbidden response has a 3xx status code
func (o *BackupsRestoreStatusForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this backups restore status forbidden response has a 4xx status code
func (o *BackupsRestoreStatusForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this backups restore status forbidden response has a 5xx status code
func (o *BackupsRestoreStatusForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this backups restore status forbidden response a status code equal to that given
func (o *BackupsRestoreStatusForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the backups restore status forbidden response
func (o *BackupsRestoreStatusForbidden) Code() int {
	return 403
}

func (o *BackupsRestoreStatusForbidden) Error() string {
	return fmt.Sprintf("[GET /backups/{backend}/{id}/restore][%d] backupsRestoreStatusForbidden  %+v", 403, o.Payload)
}

func (o *BackupsRestoreStatusForbidden) String() string {
	return fmt.Sprintf("[GET /backups/{backend}/{id}/restore][%d] backupsRestoreStatusForbidden  %+v", 403, o.Payload)
}

func (o *BackupsRestoreStatusForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BackupsRestoreStatusForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBackupsRestoreStatusNotFound creates a BackupsRestoreStatusNotFound with default headers values
func NewBackupsRestoreStatusNotFound() *BackupsRestoreStatusNotFound {
	return &BackupsRestoreStatusNotFound{}
}

/*
BackupsRestoreStatusNotFound describes a response with status code 404, with default header values.

Backup not found on the specified backend with the given ID.
*/
type BackupsRestoreStatusNotFound struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this backups restore status not found response has a 2xx status code
func (o *BackupsRestoreStatusNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this backups restore status not found response has a 3xx status code
func (o *BackupsRestoreStatusNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this backups restore status not found response has a 4xx status code
func (o *BackupsRestoreStatusNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this backups restore status not found response has a 5xx status code
func (o *BackupsRestoreStatusNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this backups restore status not found response a status code equal to that given
func (o *BackupsRestoreStatusNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the backups restore status not found response
func (o *BackupsRestoreStatusNotFound) Code() int {
	return 404
}

func (o *BackupsRestoreStatusNotFound) Error() string {
	return fmt.Sprintf("[GET /backups/{backend}/{id}/restore][%d] backupsRestoreStatusNotFound  %+v", 404, o.Payload)
}

func (o *BackupsRestoreStatusNotFound) String() string {
	return fmt.Sprintf("[GET /backups/{backend}/{id}/restore][%d] backupsRestoreStatusNotFound  %+v", 404, o.Payload)
}

func (o *BackupsRestoreStatusNotFound) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BackupsRestoreStatusNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBackupsRestoreStatusInternalServerError creates a BackupsRestoreStatusInternalServerError with default headers values
func NewBackupsRestoreStatusInternalServerError() *BackupsRestoreStatusInternalServerError {
	return &BackupsRestoreStatusInternalServerError{}
}

/*
BackupsRestoreStatusInternalServerError describes a response with status code 500, with default header values.

An internal server error occurred while checking restore status. Check the ErrorResponse for details.
*/
type BackupsRestoreStatusInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this backups restore status internal server error response has a 2xx status code
func (o *BackupsRestoreStatusInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this backups restore status internal server error response has a 3xx status code
func (o *BackupsRestoreStatusInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this backups restore status internal server error response has a 4xx status code
func (o *BackupsRestoreStatusInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this backups restore status internal server error response has a 5xx status code
func (o *BackupsRestoreStatusInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this backups restore status internal server error response a status code equal to that given
func (o *BackupsRestoreStatusInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the backups restore status internal server error response
func (o *BackupsRestoreStatusInternalServerError) Code() int {
	return 500
}

func (o *BackupsRestoreStatusInternalServerError) Error() string {
	return fmt.Sprintf("[GET /backups/{backend}/{id}/restore][%d] backupsRestoreStatusInternalServerError  %+v", 500, o.Payload)
}

func (o *BackupsRestoreStatusInternalServerError) String() string {
	return fmt.Sprintf("[GET /backups/{backend}/{id}/restore][%d] backupsRestoreStatusInternalServerError  %+v", 500, o.Payload)
}

func (o *BackupsRestoreStatusInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BackupsRestoreStatusInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
