//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package batch

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// BatchObjectsDeleteReader is a Reader for the BatchObjectsDelete structure.
type BatchObjectsDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BatchObjectsDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBatchObjectsDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewBatchObjectsDeleteBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewBatchObjectsDeleteUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewBatchObjectsDeleteForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewBatchObjectsDeleteUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewBatchObjectsDeleteInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewBatchObjectsDeleteOK creates a BatchObjectsDeleteOK with default headers values
func NewBatchObjectsDeleteOK() *BatchObjectsDeleteOK {
	return &BatchObjectsDeleteOK{}
}

/*
BatchObjectsDeleteOK describes a response with status code 200, with default header values.

Request processed successfully. See response body for matching objects and deletion results.
*/
type BatchObjectsDeleteOK struct {
	Payload *models.BatchDeleteResponse
}

// IsSuccess returns true when this batch objects delete o k response has a 2xx status code
func (o *BatchObjectsDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this batch objects delete o k response has a 3xx status code
func (o *BatchObjectsDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch objects delete o k response has a 4xx status code
func (o *BatchObjectsDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this batch objects delete o k response has a 5xx status code
func (o *BatchObjectsDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this batch objects delete o k response a status code equal to that given
func (o *BatchObjectsDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the batch objects delete o k response
func (o *BatchObjectsDeleteOK) Code() int {
	return 200
}

func (o *BatchObjectsDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteOK  %+v", 200, o.Payload)
}

func (o *BatchObjectsDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteOK  %+v", 200, o.Payload)
}

func (o *BatchObjectsDeleteOK) GetPayload() *models.BatchDeleteResponse {
	return o.Payload
}

func (o *BatchObjectsDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.BatchDeleteResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchObjectsDeleteBadRequest creates a BatchObjectsDeleteBadRequest with default headers values
func NewBatchObjectsDeleteBadRequest() *BatchObjectsDeleteBadRequest {
	return &BatchObjectsDeleteBadRequest{}
}

/*
BatchObjectsDeleteBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type BatchObjectsDeleteBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this batch objects delete bad request response has a 2xx status code
func (o *BatchObjectsDeleteBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch objects delete bad request response has a 3xx status code
func (o *BatchObjectsDeleteBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch objects delete bad request response has a 4xx status code
func (o *BatchObjectsDeleteBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch objects delete bad request response has a 5xx status code
func (o *BatchObjectsDeleteBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this batch objects delete bad request response a status code equal to that given
func (o *BatchObjectsDeleteBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the batch objects delete bad request response
func (o *BatchObjectsDeleteBadRequest) Code() int {
	return 400
}

func (o *BatchObjectsDeleteBadRequest) Error() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteBadRequest  %+v", 400, o.Payload)
}

func (o *BatchObjectsDeleteBadRequest) String() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteBadRequest  %+v", 400, o.Payload)
}

func (o *BatchObjectsDeleteBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BatchObjectsDeleteBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchObjectsDeleteUnauthorized creates a BatchObjectsDeleteUnauthorized with default headers values
func NewBatchObjectsDeleteUnauthorized() *BatchObjectsDeleteUnauthorized {
	return &BatchObjectsDeleteUnauthorized{}
}

/*
BatchObjectsDeleteUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type BatchObjectsDeleteUnauthorized struct {
}

// IsSuccess returns true when this batch objects delete unauthorized response has a 2xx status code
func (o *BatchObjectsDeleteUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch objects delete unauthorized response has a 3xx status code
func (o *BatchObjectsDeleteUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch objects delete unauthorized response has a 4xx status code
func (o *BatchObjectsDeleteUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch objects delete unauthorized response has a 5xx status code
func (o *BatchObjectsDeleteUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this batch objects delete unauthorized response a status code equal to that given
func (o *BatchObjectsDeleteUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the batch objects delete unauthorized response
func (o *BatchObjectsDeleteUnauthorized) Code() int {
	return 401
}

func (o *BatchObjectsDeleteUnauthorized) Error() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteUnauthorized ", 401)
}

func (o *BatchObjectsDeleteUnauthorized) String() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteUnauthorized ", 401)
}

func (o *BatchObjectsDeleteUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewBatchObjectsDeleteForbidden creates a BatchObjectsDeleteForbidden with default headers values
func NewBatchObjectsDeleteForbidden() *BatchObjectsDeleteForbidden {
	return &BatchObjectsDeleteForbidden{}
}

/*
BatchObjectsDeleteForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type BatchObjectsDeleteForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this batch objects delete forbidden response has a 2xx status code
func (o *BatchObjectsDeleteForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch objects delete forbidden response has a 3xx status code
func (o *BatchObjectsDeleteForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch objects delete forbidden response has a 4xx status code
func (o *BatchObjectsDeleteForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch objects delete forbidden response has a 5xx status code
func (o *BatchObjectsDeleteForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this batch objects delete forbidden response a status code equal to that given
func (o *BatchObjectsDeleteForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the batch objects delete forbidden response
func (o *BatchObjectsDeleteForbidden) Code() int {
	return 403
}

func (o *BatchObjectsDeleteForbidden) Error() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteForbidden  %+v", 403, o.Payload)
}

func (o *BatchObjectsDeleteForbidden) String() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteForbidden  %+v", 403, o.Payload)
}

func (o *BatchObjectsDeleteForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BatchObjectsDeleteForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchObjectsDeleteUnprocessableEntity creates a BatchObjectsDeleteUnprocessableEntity with default headers values
func NewBatchObjectsDeleteUnprocessableEntity() *BatchObjectsDeleteUnprocessableEntity {
	return &BatchObjectsDeleteUnprocessableEntity{}
}

/*
BatchObjectsDeleteUnprocessableEntity describes a response with status code 422, with default header values.

Invalid data provided. Please check the values in your request (e.g., invalid filter).
*/
type BatchObjectsDeleteUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this batch objects delete unprocessable entity response has a 2xx status code
func (o *BatchObjectsDeleteUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch objects delete unprocessable entity response has a 3xx status code
func (o *BatchObjectsDeleteUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch objects delete unprocessable entity response has a 4xx status code
func (o *BatchObjectsDeleteUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this batch objects delete unprocessable entity response has a 5xx status code
func (o *BatchObjectsDeleteUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this batch objects delete unprocessable entity response a status code equal to that given
func (o *BatchObjectsDeleteUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the batch objects delete unprocessable entity response
func (o *BatchObjectsDeleteUnprocessableEntity) Code() int {
	return 422
}

func (o *BatchObjectsDeleteUnprocessableEntity) Error() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *BatchObjectsDeleteUnprocessableEntity) String() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *BatchObjectsDeleteUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BatchObjectsDeleteUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBatchObjectsDeleteInternalServerError creates a BatchObjectsDeleteInternalServerError with default headers values
func NewBatchObjectsDeleteInternalServerError() *BatchObjectsDeleteInternalServerError {
	return &BatchObjectsDeleteInternalServerError{}
}

/*
BatchObjectsDeleteInternalServerError describes a response with status code 500, with default header values.

An error occurred while trying to fulfill the request. Check the ErrorResponse for details.
*/
type BatchObjectsDeleteInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this batch objects delete internal server error response has a 2xx status code
func (o *BatchObjectsDeleteInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this batch objects delete internal server error response has a 3xx status code
func (o *BatchObjectsDeleteInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this batch objects delete internal server error response has a 4xx status code
func (o *BatchObjectsDeleteInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this batch objects delete internal server error response has a 5xx status code
func (o *BatchObjectsDeleteInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this batch objects delete internal server error response a status code equal to that given
func (o *BatchObjectsDeleteInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the batch objects delete internal server error response
func (o *BatchObjectsDeleteInternalServerError) Code() int {
	return 500
}

func (o *BatchObjectsDeleteInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *BatchObjectsDeleteInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /batch/objects][%d] batchObjectsDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *BatchObjectsDeleteInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *BatchObjectsDeleteInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
