//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package distributed_tasks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// DistributedTasksGetReader is a Reader for the DistributedTasksGet structure.
type DistributedTasksGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DistributedTasksGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDistributedTasksGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewDistributedTasksGetForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDistributedTasksGetInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDistributedTasksGetOK creates a DistributedTasksGetOK with default headers values
func NewDistributedTasksGetOK() *DistributedTasksGetOK {
	return &DistributedTasksGetOK{}
}

/*
DistributedTasksGetOK describes a response with status code 200, with default header values.

Distributed tasks successfully returned.
*/
type DistributedTasksGetOK struct {
	Payload models.DistributedTasks
}

// IsSuccess returns true when this distributed tasks get o k response has a 2xx status code
func (o *DistributedTasksGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this distributed tasks get o k response has a 3xx status code
func (o *DistributedTasksGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this distributed tasks get o k response has a 4xx status code
func (o *DistributedTasksGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this distributed tasks get o k response has a 5xx status code
func (o *DistributedTasksGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this distributed tasks get o k response a status code equal to that given
func (o *DistributedTasksGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the distributed tasks get o k response
func (o *DistributedTasksGetOK) Code() int {
	return 200
}

func (o *DistributedTasksGetOK) Error() string {
	return fmt.Sprintf("[GET /tasks][%d] distributedTasksGetOK  %+v", 200, o.Payload)
}

func (o *DistributedTasksGetOK) String() string {
	return fmt.Sprintf("[GET /tasks][%d] distributedTasksGetOK  %+v", 200, o.Payload)
}

func (o *DistributedTasksGetOK) GetPayload() models.DistributedTasks {
	return o.Payload
}

func (o *DistributedTasksGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDistributedTasksGetForbidden creates a DistributedTasksGetForbidden with default headers values
func NewDistributedTasksGetForbidden() *DistributedTasksGetForbidden {
	return &DistributedTasksGetForbidden{}
}

/*
DistributedTasksGetForbidden describes a response with status code 403, with default header values.

Unauthorized or invalid credentials.
*/
type DistributedTasksGetForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this distributed tasks get forbidden response has a 2xx status code
func (o *DistributedTasksGetForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this distributed tasks get forbidden response has a 3xx status code
func (o *DistributedTasksGetForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this distributed tasks get forbidden response has a 4xx status code
func (o *DistributedTasksGetForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this distributed tasks get forbidden response has a 5xx status code
func (o *DistributedTasksGetForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this distributed tasks get forbidden response a status code equal to that given
func (o *DistributedTasksGetForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the distributed tasks get forbidden response
func (o *DistributedTasksGetForbidden) Code() int {
	return 403
}

func (o *DistributedTasksGetForbidden) Error() string {
	return fmt.Sprintf("[GET /tasks][%d] distributedTasksGetForbidden  %+v", 403, o.Payload)
}

func (o *DistributedTasksGetForbidden) String() string {
	return fmt.Sprintf("[GET /tasks][%d] distributedTasksGetForbidden  %+v", 403, o.Payload)
}

func (o *DistributedTasksGetForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DistributedTasksGetForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDistributedTasksGetInternalServerError creates a DistributedTasksGetInternalServerError with default headers values
func NewDistributedTasksGetInternalServerError() *DistributedTasksGetInternalServerError {
	return &DistributedTasksGetInternalServerError{}
}

/*
DistributedTasksGetInternalServerError describes a response with status code 500, with default header values.

An internal server error occurred while retrieving distributed tasks. Check the ErrorResponse for details.
*/
type DistributedTasksGetInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this distributed tasks get internal server error response has a 2xx status code
func (o *DistributedTasksGetInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this distributed tasks get internal server error response has a 3xx status code
func (o *DistributedTasksGetInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this distributed tasks get internal server error response has a 4xx status code
func (o *DistributedTasksGetInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this distributed tasks get internal server error response has a 5xx status code
func (o *DistributedTasksGetInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this distributed tasks get internal server error response a status code equal to that given
func (o *DistributedTasksGetInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the distributed tasks get internal server error response
func (o *DistributedTasksGetInternalServerError) Code() int {
	return 500
}

func (o *DistributedTasksGetInternalServerError) Error() string {
	return fmt.Sprintf("[GET /tasks][%d] distributedTasksGetInternalServerError  %+v", 500, o.Payload)
}

func (o *DistributedTasksGetInternalServerError) String() string {
	return fmt.Sprintf("[GET /tasks][%d] distributedTasksGetInternalServerError  %+v", 500, o.Payload)
}

func (o *DistributedTasksGetInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DistributedTasksGetInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
