//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewObjectsClassGetParams creates a new ObjectsClassGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewObjectsClassGetParams() *ObjectsClassGetParams {
	return &ObjectsClassGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewObjectsClassGetParamsWithTimeout creates a new ObjectsClassGetParams object
// with the ability to set a timeout on a request.
func NewObjectsClassGetParamsWithTimeout(timeout time.Duration) *ObjectsClassGetParams {
	return &ObjectsClassGetParams{
		timeout: timeout,
	}
}

// NewObjectsClassGetParamsWithContext creates a new ObjectsClassGetParams object
// with the ability to set a context for a request.
func NewObjectsClassGetParamsWithContext(ctx context.Context) *ObjectsClassGetParams {
	return &ObjectsClassGetParams{
		Context: ctx,
	}
}

// NewObjectsClassGetParamsWithHTTPClient creates a new ObjectsClassGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewObjectsClassGetParamsWithHTTPClient(client *http.Client) *ObjectsClassGetParams {
	return &ObjectsClassGetParams{
		HTTPClient: client,
	}
}

/*
ObjectsClassGetParams contains all the parameters to send to the API endpoint

	for the objects class get operation.

	Typically these are written to a http.Request.
*/
type ObjectsClassGetParams struct {

	/* ClassName.

	   Name of the collection (class) the object belongs to.
	*/
	ClassName string

	/* ConsistencyLevel.

	   Determines how many replicas must acknowledge a request before it is considered successful.
	*/
	ConsistencyLevel *string

	/* ID.

	   Unique UUID of the object to be retrieved.

	   Format: uuid
	*/
	ID strfmt.UUID

	/* Include.

	   Include additional information, such as classification information. Allowed values include: `classification`, `vector` and `interpretation`.
	*/
	Include *string

	/* NodeName.

	   The target node which should fulfill the request.
	*/
	NodeName *string

	/* Tenant.

	   Specifies the tenant in a request targeting a multi-tenant collection (class).
	*/
	Tenant *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the objects class get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ObjectsClassGetParams) WithDefaults() *ObjectsClassGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the objects class get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ObjectsClassGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the objects class get params
func (o *ObjectsClassGetParams) WithTimeout(timeout time.Duration) *ObjectsClassGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the objects class get params
func (o *ObjectsClassGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the objects class get params
func (o *ObjectsClassGetParams) WithContext(ctx context.Context) *ObjectsClassGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the objects class get params
func (o *ObjectsClassGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the objects class get params
func (o *ObjectsClassGetParams) WithHTTPClient(client *http.Client) *ObjectsClassGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the objects class get params
func (o *ObjectsClassGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClassName adds the className to the objects class get params
func (o *ObjectsClassGetParams) WithClassName(className string) *ObjectsClassGetParams {
	o.SetClassName(className)
	return o
}

// SetClassName adds the className to the objects class get params
func (o *ObjectsClassGetParams) SetClassName(className string) {
	o.ClassName = className
}

// WithConsistencyLevel adds the consistencyLevel to the objects class get params
func (o *ObjectsClassGetParams) WithConsistencyLevel(consistencyLevel *string) *ObjectsClassGetParams {
	o.SetConsistencyLevel(consistencyLevel)
	return o
}

// SetConsistencyLevel adds the consistencyLevel to the objects class get params
func (o *ObjectsClassGetParams) SetConsistencyLevel(consistencyLevel *string) {
	o.ConsistencyLevel = consistencyLevel
}

// WithID adds the id to the objects class get params
func (o *ObjectsClassGetParams) WithID(id strfmt.UUID) *ObjectsClassGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the objects class get params
func (o *ObjectsClassGetParams) SetID(id strfmt.UUID) {
	o.ID = id
}

// WithInclude adds the include to the objects class get params
func (o *ObjectsClassGetParams) WithInclude(include *string) *ObjectsClassGetParams {
	o.SetInclude(include)
	return o
}

// SetInclude adds the include to the objects class get params
func (o *ObjectsClassGetParams) SetInclude(include *string) {
	o.Include = include
}

// WithNodeName adds the nodeName to the objects class get params
func (o *ObjectsClassGetParams) WithNodeName(nodeName *string) *ObjectsClassGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the objects class get params
func (o *ObjectsClassGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithTenant adds the tenant to the objects class get params
func (o *ObjectsClassGetParams) WithTenant(tenant *string) *ObjectsClassGetParams {
	o.SetTenant(tenant)
	return o
}

// SetTenant adds the tenant to the objects class get params
func (o *ObjectsClassGetParams) SetTenant(tenant *string) {
	o.Tenant = tenant
}

// WriteToRequest writes these params to a swagger request
func (o *ObjectsClassGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param className
	if err := r.SetPathParam("className", o.ClassName); err != nil {
		return err
	}

	if o.ConsistencyLevel != nil {

		// query param consistency_level
		var qrConsistencyLevel string

		if o.ConsistencyLevel != nil {
			qrConsistencyLevel = *o.ConsistencyLevel
		}
		qConsistencyLevel := qrConsistencyLevel
		if qConsistencyLevel != "" {

			if err := r.SetQueryParam("consistency_level", qConsistencyLevel); err != nil {
				return err
			}
		}
	}

	// path param id
	if err := r.SetPathParam("id", o.ID.String()); err != nil {
		return err
	}

	if o.Include != nil {

		// query param include
		var qrInclude string

		if o.Include != nil {
			qrInclude = *o.Include
		}
		qInclude := qrInclude
		if qInclude != "" {

			if err := r.SetQueryParam("include", qInclude); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node_name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node_name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.Tenant != nil {

		// query param tenant
		var qrTenant string

		if o.Tenant != nil {
			qrTenant = *o.Tenant
		}
		qTenant := qrTenant
		if qTenant != "" {

			if err := r.SetQueryParam("tenant", qTenant); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
