//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// NewObjectsClassPutParams creates a new ObjectsClassPutParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewObjectsClassPutParams() *ObjectsClassPutParams {
	return &ObjectsClassPutParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewObjectsClassPutParamsWithTimeout creates a new ObjectsClassPutParams object
// with the ability to set a timeout on a request.
func NewObjectsClassPutParamsWithTimeout(timeout time.Duration) *ObjectsClassPutParams {
	return &ObjectsClassPutParams{
		timeout: timeout,
	}
}

// NewObjectsClassPutParamsWithContext creates a new ObjectsClassPutParams object
// with the ability to set a context for a request.
func NewObjectsClassPutParamsWithContext(ctx context.Context) *ObjectsClassPutParams {
	return &ObjectsClassPutParams{
		Context: ctx,
	}
}

// NewObjectsClassPutParamsWithHTTPClient creates a new ObjectsClassPutParams object
// with the ability to set a custom HTTPClient for a request.
func NewObjectsClassPutParamsWithHTTPClient(client *http.Client) *ObjectsClassPutParams {
	return &ObjectsClassPutParams{
		HTTPClient: client,
	}
}

/*
ObjectsClassPutParams contains all the parameters to send to the API endpoint

	for the objects class put operation.

	Typically these are written to a http.Request.
*/
type ObjectsClassPutParams struct {

	/* Body.

	   The object definition to replace the existing object with.
	*/
	Body *models.Object

	/* ClassName.

	   Name of the collection (class) the object belongs to.
	*/
	ClassName string

	/* ConsistencyLevel.

	   Determines how many replicas must acknowledge a request before it is considered successful.
	*/
	ConsistencyLevel *string

	/* ID.

	   Unique UUID of the object to be replaced.

	   Format: uuid
	*/
	ID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the objects class put params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ObjectsClassPutParams) WithDefaults() *ObjectsClassPutParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the objects class put params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ObjectsClassPutParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the objects class put params
func (o *ObjectsClassPutParams) WithTimeout(timeout time.Duration) *ObjectsClassPutParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the objects class put params
func (o *ObjectsClassPutParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the objects class put params
func (o *ObjectsClassPutParams) WithContext(ctx context.Context) *ObjectsClassPutParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the objects class put params
func (o *ObjectsClassPutParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the objects class put params
func (o *ObjectsClassPutParams) WithHTTPClient(client *http.Client) *ObjectsClassPutParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the objects class put params
func (o *ObjectsClassPutParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the objects class put params
func (o *ObjectsClassPutParams) WithBody(body *models.Object) *ObjectsClassPutParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the objects class put params
func (o *ObjectsClassPutParams) SetBody(body *models.Object) {
	o.Body = body
}

// WithClassName adds the className to the objects class put params
func (o *ObjectsClassPutParams) WithClassName(className string) *ObjectsClassPutParams {
	o.SetClassName(className)
	return o
}

// SetClassName adds the className to the objects class put params
func (o *ObjectsClassPutParams) SetClassName(className string) {
	o.ClassName = className
}

// WithConsistencyLevel adds the consistencyLevel to the objects class put params
func (o *ObjectsClassPutParams) WithConsistencyLevel(consistencyLevel *string) *ObjectsClassPutParams {
	o.SetConsistencyLevel(consistencyLevel)
	return o
}

// SetConsistencyLevel adds the consistencyLevel to the objects class put params
func (o *ObjectsClassPutParams) SetConsistencyLevel(consistencyLevel *string) {
	o.ConsistencyLevel = consistencyLevel
}

// WithID adds the id to the objects class put params
func (o *ObjectsClassPutParams) WithID(id strfmt.UUID) *ObjectsClassPutParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the objects class put params
func (o *ObjectsClassPutParams) SetID(id strfmt.UUID) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *ObjectsClassPutParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param className
	if err := r.SetPathParam("className", o.ClassName); err != nil {
		return err
	}

	if o.ConsistencyLevel != nil {

		// query param consistency_level
		var qrConsistencyLevel string

		if o.ConsistencyLevel != nil {
			qrConsistencyLevel = *o.ConsistencyLevel
		}
		qConsistencyLevel := qrConsistencyLevel
		if qConsistencyLevel != "" {

			if err := r.SetQueryParam("consistency_level", qConsistencyLevel); err != nil {
				return err
			}
		}
	}

	// path param id
	if err := r.SetPathParam("id", o.ID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
