//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsHeadReader is a Reader for the ObjectsHead structure.
type ObjectsHeadReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ObjectsHeadReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewObjectsHeadNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewObjectsHeadUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewObjectsHeadForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewObjectsHeadNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewObjectsHeadInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewObjectsHeadNoContent creates a ObjectsHeadNoContent with default headers values
func NewObjectsHeadNoContent() *ObjectsHeadNoContent {
	return &ObjectsHeadNoContent{}
}

/*
ObjectsHeadNoContent describes a response with status code 204, with default header values.

Object exists.
*/
type ObjectsHeadNoContent struct {
}

// IsSuccess returns true when this objects head no content response has a 2xx status code
func (o *ObjectsHeadNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this objects head no content response has a 3xx status code
func (o *ObjectsHeadNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects head no content response has a 4xx status code
func (o *ObjectsHeadNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects head no content response has a 5xx status code
func (o *ObjectsHeadNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this objects head no content response a status code equal to that given
func (o *ObjectsHeadNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the objects head no content response
func (o *ObjectsHeadNoContent) Code() int {
	return 204
}

func (o *ObjectsHeadNoContent) Error() string {
	return fmt.Sprintf("[HEAD /objects/{id}][%d] objectsHeadNoContent ", 204)
}

func (o *ObjectsHeadNoContent) String() string {
	return fmt.Sprintf("[HEAD /objects/{id}][%d] objectsHeadNoContent ", 204)
}

func (o *ObjectsHeadNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsHeadUnauthorized creates a ObjectsHeadUnauthorized with default headers values
func NewObjectsHeadUnauthorized() *ObjectsHeadUnauthorized {
	return &ObjectsHeadUnauthorized{}
}

/*
ObjectsHeadUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ObjectsHeadUnauthorized struct {
}

// IsSuccess returns true when this objects head unauthorized response has a 2xx status code
func (o *ObjectsHeadUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects head unauthorized response has a 3xx status code
func (o *ObjectsHeadUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects head unauthorized response has a 4xx status code
func (o *ObjectsHeadUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects head unauthorized response has a 5xx status code
func (o *ObjectsHeadUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this objects head unauthorized response a status code equal to that given
func (o *ObjectsHeadUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the objects head unauthorized response
func (o *ObjectsHeadUnauthorized) Code() int {
	return 401
}

func (o *ObjectsHeadUnauthorized) Error() string {
	return fmt.Sprintf("[HEAD /objects/{id}][%d] objectsHeadUnauthorized ", 401)
}

func (o *ObjectsHeadUnauthorized) String() string {
	return fmt.Sprintf("[HEAD /objects/{id}][%d] objectsHeadUnauthorized ", 401)
}

func (o *ObjectsHeadUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsHeadForbidden creates a ObjectsHeadForbidden with default headers values
func NewObjectsHeadForbidden() *ObjectsHeadForbidden {
	return &ObjectsHeadForbidden{}
}

/*
ObjectsHeadForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ObjectsHeadForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects head forbidden response has a 2xx status code
func (o *ObjectsHeadForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects head forbidden response has a 3xx status code
func (o *ObjectsHeadForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects head forbidden response has a 4xx status code
func (o *ObjectsHeadForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects head forbidden response has a 5xx status code
func (o *ObjectsHeadForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this objects head forbidden response a status code equal to that given
func (o *ObjectsHeadForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the objects head forbidden response
func (o *ObjectsHeadForbidden) Code() int {
	return 403
}

func (o *ObjectsHeadForbidden) Error() string {
	return fmt.Sprintf("[HEAD /objects/{id}][%d] objectsHeadForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsHeadForbidden) String() string {
	return fmt.Sprintf("[HEAD /objects/{id}][%d] objectsHeadForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsHeadForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsHeadForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsHeadNotFound creates a ObjectsHeadNotFound with default headers values
func NewObjectsHeadNotFound() *ObjectsHeadNotFound {
	return &ObjectsHeadNotFound{}
}

/*
ObjectsHeadNotFound describes a response with status code 404, with default header values.

Object does not exist.
*/
type ObjectsHeadNotFound struct {
}

// IsSuccess returns true when this objects head not found response has a 2xx status code
func (o *ObjectsHeadNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects head not found response has a 3xx status code
func (o *ObjectsHeadNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects head not found response has a 4xx status code
func (o *ObjectsHeadNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects head not found response has a 5xx status code
func (o *ObjectsHeadNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this objects head not found response a status code equal to that given
func (o *ObjectsHeadNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the objects head not found response
func (o *ObjectsHeadNotFound) Code() int {
	return 404
}

func (o *ObjectsHeadNotFound) Error() string {
	return fmt.Sprintf("[HEAD /objects/{id}][%d] objectsHeadNotFound ", 404)
}

func (o *ObjectsHeadNotFound) String() string {
	return fmt.Sprintf("[HEAD /objects/{id}][%d] objectsHeadNotFound ", 404)
}

func (o *ObjectsHeadNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsHeadInternalServerError creates a ObjectsHeadInternalServerError with default headers values
func NewObjectsHeadInternalServerError() *ObjectsHeadInternalServerError {
	return &ObjectsHeadInternalServerError{}
}

/*
ObjectsHeadInternalServerError describes a response with status code 500, with default header values.

An error occurred while trying to fulfill the request. Check the ErrorResponse for details.
*/
type ObjectsHeadInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects head internal server error response has a 2xx status code
func (o *ObjectsHeadInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects head internal server error response has a 3xx status code
func (o *ObjectsHeadInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects head internal server error response has a 4xx status code
func (o *ObjectsHeadInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects head internal server error response has a 5xx status code
func (o *ObjectsHeadInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this objects head internal server error response a status code equal to that given
func (o *ObjectsHeadInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the objects head internal server error response
func (o *ObjectsHeadInternalServerError) Code() int {
	return 500
}

func (o *ObjectsHeadInternalServerError) Error() string {
	return fmt.Sprintf("[HEAD /objects/{id}][%d] objectsHeadInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsHeadInternalServerError) String() string {
	return fmt.Sprintf("[HEAD /objects/{id}][%d] objectsHeadInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsHeadInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsHeadInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
