//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsReferencesCreateReader is a Reader for the ObjectsReferencesCreate structure.
type ObjectsReferencesCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ObjectsReferencesCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewObjectsReferencesCreateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewObjectsReferencesCreateUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewObjectsReferencesCreateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewObjectsReferencesCreateUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewObjectsReferencesCreateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewObjectsReferencesCreateOK creates a ObjectsReferencesCreateOK with default headers values
func NewObjectsReferencesCreateOK() *ObjectsReferencesCreateOK {
	return &ObjectsReferencesCreateOK{}
}

/*
ObjectsReferencesCreateOK describes a response with status code 200, with default header values.

Reference added successfully.
*/
type ObjectsReferencesCreateOK struct {
}

// IsSuccess returns true when this objects references create o k response has a 2xx status code
func (o *ObjectsReferencesCreateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this objects references create o k response has a 3xx status code
func (o *ObjectsReferencesCreateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects references create o k response has a 4xx status code
func (o *ObjectsReferencesCreateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects references create o k response has a 5xx status code
func (o *ObjectsReferencesCreateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this objects references create o k response a status code equal to that given
func (o *ObjectsReferencesCreateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the objects references create o k response
func (o *ObjectsReferencesCreateOK) Code() int {
	return 200
}

func (o *ObjectsReferencesCreateOK) Error() string {
	return fmt.Sprintf("[POST /objects/{id}/references/{propertyName}][%d] objectsReferencesCreateOK ", 200)
}

func (o *ObjectsReferencesCreateOK) String() string {
	return fmt.Sprintf("[POST /objects/{id}/references/{propertyName}][%d] objectsReferencesCreateOK ", 200)
}

func (o *ObjectsReferencesCreateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsReferencesCreateUnauthorized creates a ObjectsReferencesCreateUnauthorized with default headers values
func NewObjectsReferencesCreateUnauthorized() *ObjectsReferencesCreateUnauthorized {
	return &ObjectsReferencesCreateUnauthorized{}
}

/*
ObjectsReferencesCreateUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ObjectsReferencesCreateUnauthorized struct {
}

// IsSuccess returns true when this objects references create unauthorized response has a 2xx status code
func (o *ObjectsReferencesCreateUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects references create unauthorized response has a 3xx status code
func (o *ObjectsReferencesCreateUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects references create unauthorized response has a 4xx status code
func (o *ObjectsReferencesCreateUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects references create unauthorized response has a 5xx status code
func (o *ObjectsReferencesCreateUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this objects references create unauthorized response a status code equal to that given
func (o *ObjectsReferencesCreateUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the objects references create unauthorized response
func (o *ObjectsReferencesCreateUnauthorized) Code() int {
	return 401
}

func (o *ObjectsReferencesCreateUnauthorized) Error() string {
	return fmt.Sprintf("[POST /objects/{id}/references/{propertyName}][%d] objectsReferencesCreateUnauthorized ", 401)
}

func (o *ObjectsReferencesCreateUnauthorized) String() string {
	return fmt.Sprintf("[POST /objects/{id}/references/{propertyName}][%d] objectsReferencesCreateUnauthorized ", 401)
}

func (o *ObjectsReferencesCreateUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsReferencesCreateForbidden creates a ObjectsReferencesCreateForbidden with default headers values
func NewObjectsReferencesCreateForbidden() *ObjectsReferencesCreateForbidden {
	return &ObjectsReferencesCreateForbidden{}
}

/*
ObjectsReferencesCreateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ObjectsReferencesCreateForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects references create forbidden response has a 2xx status code
func (o *ObjectsReferencesCreateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects references create forbidden response has a 3xx status code
func (o *ObjectsReferencesCreateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects references create forbidden response has a 4xx status code
func (o *ObjectsReferencesCreateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects references create forbidden response has a 5xx status code
func (o *ObjectsReferencesCreateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this objects references create forbidden response a status code equal to that given
func (o *ObjectsReferencesCreateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the objects references create forbidden response
func (o *ObjectsReferencesCreateForbidden) Code() int {
	return 403
}

func (o *ObjectsReferencesCreateForbidden) Error() string {
	return fmt.Sprintf("[POST /objects/{id}/references/{propertyName}][%d] objectsReferencesCreateForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsReferencesCreateForbidden) String() string {
	return fmt.Sprintf("[POST /objects/{id}/references/{propertyName}][%d] objectsReferencesCreateForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsReferencesCreateForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsReferencesCreateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsReferencesCreateUnprocessableEntity creates a ObjectsReferencesCreateUnprocessableEntity with default headers values
func NewObjectsReferencesCreateUnprocessableEntity() *ObjectsReferencesCreateUnprocessableEntity {
	return &ObjectsReferencesCreateUnprocessableEntity{}
}

/*
ObjectsReferencesCreateUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request. Ensure the property exists and is a reference type.
*/
type ObjectsReferencesCreateUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects references create unprocessable entity response has a 2xx status code
func (o *ObjectsReferencesCreateUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects references create unprocessable entity response has a 3xx status code
func (o *ObjectsReferencesCreateUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects references create unprocessable entity response has a 4xx status code
func (o *ObjectsReferencesCreateUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects references create unprocessable entity response has a 5xx status code
func (o *ObjectsReferencesCreateUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this objects references create unprocessable entity response a status code equal to that given
func (o *ObjectsReferencesCreateUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the objects references create unprocessable entity response
func (o *ObjectsReferencesCreateUnprocessableEntity) Code() int {
	return 422
}

func (o *ObjectsReferencesCreateUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /objects/{id}/references/{propertyName}][%d] objectsReferencesCreateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsReferencesCreateUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /objects/{id}/references/{propertyName}][%d] objectsReferencesCreateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsReferencesCreateUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsReferencesCreateUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsReferencesCreateInternalServerError creates a ObjectsReferencesCreateInternalServerError with default headers values
func NewObjectsReferencesCreateInternalServerError() *ObjectsReferencesCreateInternalServerError {
	return &ObjectsReferencesCreateInternalServerError{}
}

/*
ObjectsReferencesCreateInternalServerError describes a response with status code 500, with default header values.

An error occurred while trying to fulfill the request. Check the ErrorResponse for details.
*/
type ObjectsReferencesCreateInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects references create internal server error response has a 2xx status code
func (o *ObjectsReferencesCreateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects references create internal server error response has a 3xx status code
func (o *ObjectsReferencesCreateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects references create internal server error response has a 4xx status code
func (o *ObjectsReferencesCreateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects references create internal server error response has a 5xx status code
func (o *ObjectsReferencesCreateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this objects references create internal server error response a status code equal to that given
func (o *ObjectsReferencesCreateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the objects references create internal server error response
func (o *ObjectsReferencesCreateInternalServerError) Code() int {
	return 500
}

func (o *ObjectsReferencesCreateInternalServerError) Error() string {
	return fmt.Sprintf("[POST /objects/{id}/references/{propertyName}][%d] objectsReferencesCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsReferencesCreateInternalServerError) String() string {
	return fmt.Sprintf("[POST /objects/{id}/references/{propertyName}][%d] objectsReferencesCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsReferencesCreateInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsReferencesCreateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
