//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package objects

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ObjectsValidateReader is a Reader for the ObjectsValidate structure.
type ObjectsValidateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ObjectsValidateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewObjectsValidateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewObjectsValidateUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewObjectsValidateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewObjectsValidateUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewObjectsValidateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewObjectsValidateOK creates a ObjectsValidateOK with default headers values
func NewObjectsValidateOK() *ObjectsValidateOK {
	return &ObjectsValidateOK{}
}

/*
ObjectsValidateOK describes a response with status code 200, with default header values.

Object is valid according to the schema.
*/
type ObjectsValidateOK struct {
}

// IsSuccess returns true when this objects validate o k response has a 2xx status code
func (o *ObjectsValidateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this objects validate o k response has a 3xx status code
func (o *ObjectsValidateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects validate o k response has a 4xx status code
func (o *ObjectsValidateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects validate o k response has a 5xx status code
func (o *ObjectsValidateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this objects validate o k response a status code equal to that given
func (o *ObjectsValidateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the objects validate o k response
func (o *ObjectsValidateOK) Code() int {
	return 200
}

func (o *ObjectsValidateOK) Error() string {
	return fmt.Sprintf("[POST /objects/validate][%d] objectsValidateOK ", 200)
}

func (o *ObjectsValidateOK) String() string {
	return fmt.Sprintf("[POST /objects/validate][%d] objectsValidateOK ", 200)
}

func (o *ObjectsValidateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsValidateUnauthorized creates a ObjectsValidateUnauthorized with default headers values
func NewObjectsValidateUnauthorized() *ObjectsValidateUnauthorized {
	return &ObjectsValidateUnauthorized{}
}

/*
ObjectsValidateUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ObjectsValidateUnauthorized struct {
}

// IsSuccess returns true when this objects validate unauthorized response has a 2xx status code
func (o *ObjectsValidateUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects validate unauthorized response has a 3xx status code
func (o *ObjectsValidateUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects validate unauthorized response has a 4xx status code
func (o *ObjectsValidateUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects validate unauthorized response has a 5xx status code
func (o *ObjectsValidateUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this objects validate unauthorized response a status code equal to that given
func (o *ObjectsValidateUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the objects validate unauthorized response
func (o *ObjectsValidateUnauthorized) Code() int {
	return 401
}

func (o *ObjectsValidateUnauthorized) Error() string {
	return fmt.Sprintf("[POST /objects/validate][%d] objectsValidateUnauthorized ", 401)
}

func (o *ObjectsValidateUnauthorized) String() string {
	return fmt.Sprintf("[POST /objects/validate][%d] objectsValidateUnauthorized ", 401)
}

func (o *ObjectsValidateUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewObjectsValidateForbidden creates a ObjectsValidateForbidden with default headers values
func NewObjectsValidateForbidden() *ObjectsValidateForbidden {
	return &ObjectsValidateForbidden{}
}

/*
ObjectsValidateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ObjectsValidateForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects validate forbidden response has a 2xx status code
func (o *ObjectsValidateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects validate forbidden response has a 3xx status code
func (o *ObjectsValidateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects validate forbidden response has a 4xx status code
func (o *ObjectsValidateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects validate forbidden response has a 5xx status code
func (o *ObjectsValidateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this objects validate forbidden response a status code equal to that given
func (o *ObjectsValidateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the objects validate forbidden response
func (o *ObjectsValidateForbidden) Code() int {
	return 403
}

func (o *ObjectsValidateForbidden) Error() string {
	return fmt.Sprintf("[POST /objects/validate][%d] objectsValidateForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsValidateForbidden) String() string {
	return fmt.Sprintf("[POST /objects/validate][%d] objectsValidateForbidden  %+v", 403, o.Payload)
}

func (o *ObjectsValidateForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsValidateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsValidateUnprocessableEntity creates a ObjectsValidateUnprocessableEntity with default headers values
func NewObjectsValidateUnprocessableEntity() *ObjectsValidateUnprocessableEntity {
	return &ObjectsValidateUnprocessableEntity{}
}

/*
ObjectsValidateUnprocessableEntity describes a response with status code 422, with default header values.

Request body is well-formed but the object is invalid according to the schema.
*/
type ObjectsValidateUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects validate unprocessable entity response has a 2xx status code
func (o *ObjectsValidateUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects validate unprocessable entity response has a 3xx status code
func (o *ObjectsValidateUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects validate unprocessable entity response has a 4xx status code
func (o *ObjectsValidateUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this objects validate unprocessable entity response has a 5xx status code
func (o *ObjectsValidateUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this objects validate unprocessable entity response a status code equal to that given
func (o *ObjectsValidateUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the objects validate unprocessable entity response
func (o *ObjectsValidateUnprocessableEntity) Code() int {
	return 422
}

func (o *ObjectsValidateUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /objects/validate][%d] objectsValidateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsValidateUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /objects/validate][%d] objectsValidateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *ObjectsValidateUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsValidateUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewObjectsValidateInternalServerError creates a ObjectsValidateInternalServerError with default headers values
func NewObjectsValidateInternalServerError() *ObjectsValidateInternalServerError {
	return &ObjectsValidateInternalServerError{}
}

/*
ObjectsValidateInternalServerError describes a response with status code 500, with default header values.

An error occurred while trying to fulfill the request. Check the ErrorResponse for details.
*/
type ObjectsValidateInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this objects validate internal server error response has a 2xx status code
func (o *ObjectsValidateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this objects validate internal server error response has a 3xx status code
func (o *ObjectsValidateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this objects validate internal server error response has a 4xx status code
func (o *ObjectsValidateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this objects validate internal server error response has a 5xx status code
func (o *ObjectsValidateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this objects validate internal server error response a status code equal to that given
func (o *ObjectsValidateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the objects validate internal server error response
func (o *ObjectsValidateInternalServerError) Code() int {
	return 500
}

func (o *ObjectsValidateInternalServerError) Error() string {
	return fmt.Sprintf("[POST /objects/validate][%d] objectsValidateInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsValidateInternalServerError) String() string {
	return fmt.Sprintf("[POST /objects/validate][%d] objectsValidateInternalServerError  %+v", 500, o.Payload)
}

func (o *ObjectsValidateInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ObjectsValidateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
