//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// WeaviateWellknownReadinessReader is a Reader for the WeaviateWellknownReadiness structure.
type WeaviateWellknownReadinessReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WeaviateWellknownReadinessReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWeaviateWellknownReadinessOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 503:
		result := NewWeaviateWellknownReadinessServiceUnavailable()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewWeaviateWellknownReadinessOK creates a WeaviateWellknownReadinessOK with default headers values
func NewWeaviateWellknownReadinessOK() *WeaviateWellknownReadinessOK {
	return &WeaviateWellknownReadinessOK{}
}

/*
WeaviateWellknownReadinessOK describes a response with status code 200, with default header values.

The application is ready to serve traffic.
*/
type WeaviateWellknownReadinessOK struct {
}

// IsSuccess returns true when this weaviate wellknown readiness o k response has a 2xx status code
func (o *WeaviateWellknownReadinessOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this weaviate wellknown readiness o k response has a 3xx status code
func (o *WeaviateWellknownReadinessOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this weaviate wellknown readiness o k response has a 4xx status code
func (o *WeaviateWellknownReadinessOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this weaviate wellknown readiness o k response has a 5xx status code
func (o *WeaviateWellknownReadinessOK) IsServerError() bool {
	return false
}

// IsCode returns true when this weaviate wellknown readiness o k response a status code equal to that given
func (o *WeaviateWellknownReadinessOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the weaviate wellknown readiness o k response
func (o *WeaviateWellknownReadinessOK) Code() int {
	return 200
}

func (o *WeaviateWellknownReadinessOK) Error() string {
	return fmt.Sprintf("[GET /.well-known/ready][%d] weaviateWellknownReadinessOK ", 200)
}

func (o *WeaviateWellknownReadinessOK) String() string {
	return fmt.Sprintf("[GET /.well-known/ready][%d] weaviateWellknownReadinessOK ", 200)
}

func (o *WeaviateWellknownReadinessOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewWeaviateWellknownReadinessServiceUnavailable creates a WeaviateWellknownReadinessServiceUnavailable with default headers values
func NewWeaviateWellknownReadinessServiceUnavailable() *WeaviateWellknownReadinessServiceUnavailable {
	return &WeaviateWellknownReadinessServiceUnavailable{}
}

/*
WeaviateWellknownReadinessServiceUnavailable describes a response with status code 503, with default header values.

The application is not ready to serve traffic. Traffic should be directed to other available replicas if applicable.
*/
type WeaviateWellknownReadinessServiceUnavailable struct {
}

// IsSuccess returns true when this weaviate wellknown readiness service unavailable response has a 2xx status code
func (o *WeaviateWellknownReadinessServiceUnavailable) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this weaviate wellknown readiness service unavailable response has a 3xx status code
func (o *WeaviateWellknownReadinessServiceUnavailable) IsRedirect() bool {
	return false
}

// IsClientError returns true when this weaviate wellknown readiness service unavailable response has a 4xx status code
func (o *WeaviateWellknownReadinessServiceUnavailable) IsClientError() bool {
	return false
}

// IsServerError returns true when this weaviate wellknown readiness service unavailable response has a 5xx status code
func (o *WeaviateWellknownReadinessServiceUnavailable) IsServerError() bool {
	return true
}

// IsCode returns true when this weaviate wellknown readiness service unavailable response a status code equal to that given
func (o *WeaviateWellknownReadinessServiceUnavailable) IsCode(code int) bool {
	return code == 503
}

// Code gets the status code for the weaviate wellknown readiness service unavailable response
func (o *WeaviateWellknownReadinessServiceUnavailable) Code() int {
	return 503
}

func (o *WeaviateWellknownReadinessServiceUnavailable) Error() string {
	return fmt.Sprintf("[GET /.well-known/ready][%d] weaviateWellknownReadinessServiceUnavailable ", 503)
}

func (o *WeaviateWellknownReadinessServiceUnavailable) String() string {
	return fmt.Sprintf("[GET /.well-known/ready][%d] weaviateWellknownReadinessServiceUnavailable ", 503)
}

func (o *WeaviateWellknownReadinessServiceUnavailable) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
