//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// NewApplyReplicationScalePlanParams creates a new ApplyReplicationScalePlanParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewApplyReplicationScalePlanParams() *ApplyReplicationScalePlanParams {
	return &ApplyReplicationScalePlanParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewApplyReplicationScalePlanParamsWithTimeout creates a new ApplyReplicationScalePlanParams object
// with the ability to set a timeout on a request.
func NewApplyReplicationScalePlanParamsWithTimeout(timeout time.Duration) *ApplyReplicationScalePlanParams {
	return &ApplyReplicationScalePlanParams{
		timeout: timeout,
	}
}

// NewApplyReplicationScalePlanParamsWithContext creates a new ApplyReplicationScalePlanParams object
// with the ability to set a context for a request.
func NewApplyReplicationScalePlanParamsWithContext(ctx context.Context) *ApplyReplicationScalePlanParams {
	return &ApplyReplicationScalePlanParams{
		Context: ctx,
	}
}

// NewApplyReplicationScalePlanParamsWithHTTPClient creates a new ApplyReplicationScalePlanParams object
// with the ability to set a custom HTTPClient for a request.
func NewApplyReplicationScalePlanParamsWithHTTPClient(client *http.Client) *ApplyReplicationScalePlanParams {
	return &ApplyReplicationScalePlanParams{
		HTTPClient: client,
	}
}

/*
ApplyReplicationScalePlanParams contains all the parameters to send to the API endpoint

	for the apply replication scale plan operation.

	Typically these are written to a http.Request.
*/
type ApplyReplicationScalePlanParams struct {

	/* Body.

	   The replication scaling plan specifying the collection and its shard-level replica adjustments.
	*/
	Body *models.ReplicationScalePlan

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the apply replication scale plan params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplyReplicationScalePlanParams) WithDefaults() *ApplyReplicationScalePlanParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the apply replication scale plan params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplyReplicationScalePlanParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the apply replication scale plan params
func (o *ApplyReplicationScalePlanParams) WithTimeout(timeout time.Duration) *ApplyReplicationScalePlanParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the apply replication scale plan params
func (o *ApplyReplicationScalePlanParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the apply replication scale plan params
func (o *ApplyReplicationScalePlanParams) WithContext(ctx context.Context) *ApplyReplicationScalePlanParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the apply replication scale plan params
func (o *ApplyReplicationScalePlanParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the apply replication scale plan params
func (o *ApplyReplicationScalePlanParams) WithHTTPClient(client *http.Client) *ApplyReplicationScalePlanParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the apply replication scale plan params
func (o *ApplyReplicationScalePlanParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the apply replication scale plan params
func (o *ApplyReplicationScalePlanParams) WithBody(body *models.ReplicationScalePlan) *ApplyReplicationScalePlanParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the apply replication scale plan params
func (o *ApplyReplicationScalePlanParams) SetBody(body *models.ReplicationScalePlan) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *ApplyReplicationScalePlanParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
