//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ApplyReplicationScalePlanReader is a Reader for the ApplyReplicationScalePlan structure.
type ApplyReplicationScalePlanReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplyReplicationScalePlanReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewApplyReplicationScalePlanOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewApplyReplicationScalePlanBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewApplyReplicationScalePlanUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewApplyReplicationScalePlanForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewApplyReplicationScalePlanNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewApplyReplicationScalePlanInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewApplyReplicationScalePlanNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewApplyReplicationScalePlanOK creates a ApplyReplicationScalePlanOK with default headers values
func NewApplyReplicationScalePlanOK() *ApplyReplicationScalePlanOK {
	return &ApplyReplicationScalePlanOK{}
}

/*
ApplyReplicationScalePlanOK describes a response with status code 200, with default header values.

List of replication shard copy operation IDs initiated for the scale operation
*/
type ApplyReplicationScalePlanOK struct {
	Payload *models.ReplicationScaleApplyResponse
}

// IsSuccess returns true when this apply replication scale plan o k response has a 2xx status code
func (o *ApplyReplicationScalePlanOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this apply replication scale plan o k response has a 3xx status code
func (o *ApplyReplicationScalePlanOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this apply replication scale plan o k response has a 4xx status code
func (o *ApplyReplicationScalePlanOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this apply replication scale plan o k response has a 5xx status code
func (o *ApplyReplicationScalePlanOK) IsServerError() bool {
	return false
}

// IsCode returns true when this apply replication scale plan o k response a status code equal to that given
func (o *ApplyReplicationScalePlanOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the apply replication scale plan o k response
func (o *ApplyReplicationScalePlanOK) Code() int {
	return 200
}

func (o *ApplyReplicationScalePlanOK) Error() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanOK  %+v", 200, o.Payload)
}

func (o *ApplyReplicationScalePlanOK) String() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanOK  %+v", 200, o.Payload)
}

func (o *ApplyReplicationScalePlanOK) GetPayload() *models.ReplicationScaleApplyResponse {
	return o.Payload
}

func (o *ApplyReplicationScalePlanOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ReplicationScaleApplyResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplyReplicationScalePlanBadRequest creates a ApplyReplicationScalePlanBadRequest with default headers values
func NewApplyReplicationScalePlanBadRequest() *ApplyReplicationScalePlanBadRequest {
	return &ApplyReplicationScalePlanBadRequest{}
}

/*
ApplyReplicationScalePlanBadRequest describes a response with status code 400, with default header values.

Bad request.
*/
type ApplyReplicationScalePlanBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this apply replication scale plan bad request response has a 2xx status code
func (o *ApplyReplicationScalePlanBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this apply replication scale plan bad request response has a 3xx status code
func (o *ApplyReplicationScalePlanBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this apply replication scale plan bad request response has a 4xx status code
func (o *ApplyReplicationScalePlanBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this apply replication scale plan bad request response has a 5xx status code
func (o *ApplyReplicationScalePlanBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this apply replication scale plan bad request response a status code equal to that given
func (o *ApplyReplicationScalePlanBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the apply replication scale plan bad request response
func (o *ApplyReplicationScalePlanBadRequest) Code() int {
	return 400
}

func (o *ApplyReplicationScalePlanBadRequest) Error() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanBadRequest  %+v", 400, o.Payload)
}

func (o *ApplyReplicationScalePlanBadRequest) String() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanBadRequest  %+v", 400, o.Payload)
}

func (o *ApplyReplicationScalePlanBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplyReplicationScalePlanBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplyReplicationScalePlanUnauthorized creates a ApplyReplicationScalePlanUnauthorized with default headers values
func NewApplyReplicationScalePlanUnauthorized() *ApplyReplicationScalePlanUnauthorized {
	return &ApplyReplicationScalePlanUnauthorized{}
}

/*
ApplyReplicationScalePlanUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ApplyReplicationScalePlanUnauthorized struct {
}

// IsSuccess returns true when this apply replication scale plan unauthorized response has a 2xx status code
func (o *ApplyReplicationScalePlanUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this apply replication scale plan unauthorized response has a 3xx status code
func (o *ApplyReplicationScalePlanUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this apply replication scale plan unauthorized response has a 4xx status code
func (o *ApplyReplicationScalePlanUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this apply replication scale plan unauthorized response has a 5xx status code
func (o *ApplyReplicationScalePlanUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this apply replication scale plan unauthorized response a status code equal to that given
func (o *ApplyReplicationScalePlanUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the apply replication scale plan unauthorized response
func (o *ApplyReplicationScalePlanUnauthorized) Code() int {
	return 401
}

func (o *ApplyReplicationScalePlanUnauthorized) Error() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanUnauthorized ", 401)
}

func (o *ApplyReplicationScalePlanUnauthorized) String() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanUnauthorized ", 401)
}

func (o *ApplyReplicationScalePlanUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewApplyReplicationScalePlanForbidden creates a ApplyReplicationScalePlanForbidden with default headers values
func NewApplyReplicationScalePlanForbidden() *ApplyReplicationScalePlanForbidden {
	return &ApplyReplicationScalePlanForbidden{}
}

/*
ApplyReplicationScalePlanForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ApplyReplicationScalePlanForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this apply replication scale plan forbidden response has a 2xx status code
func (o *ApplyReplicationScalePlanForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this apply replication scale plan forbidden response has a 3xx status code
func (o *ApplyReplicationScalePlanForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this apply replication scale plan forbidden response has a 4xx status code
func (o *ApplyReplicationScalePlanForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this apply replication scale plan forbidden response has a 5xx status code
func (o *ApplyReplicationScalePlanForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this apply replication scale plan forbidden response a status code equal to that given
func (o *ApplyReplicationScalePlanForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the apply replication scale plan forbidden response
func (o *ApplyReplicationScalePlanForbidden) Code() int {
	return 403
}

func (o *ApplyReplicationScalePlanForbidden) Error() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanForbidden  %+v", 403, o.Payload)
}

func (o *ApplyReplicationScalePlanForbidden) String() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanForbidden  %+v", 403, o.Payload)
}

func (o *ApplyReplicationScalePlanForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplyReplicationScalePlanForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplyReplicationScalePlanNotFound creates a ApplyReplicationScalePlanNotFound with default headers values
func NewApplyReplicationScalePlanNotFound() *ApplyReplicationScalePlanNotFound {
	return &ApplyReplicationScalePlanNotFound{}
}

/*
ApplyReplicationScalePlanNotFound describes a response with status code 404, with default header values.

Collection not found.
*/
type ApplyReplicationScalePlanNotFound struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this apply replication scale plan not found response has a 2xx status code
func (o *ApplyReplicationScalePlanNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this apply replication scale plan not found response has a 3xx status code
func (o *ApplyReplicationScalePlanNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this apply replication scale plan not found response has a 4xx status code
func (o *ApplyReplicationScalePlanNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this apply replication scale plan not found response has a 5xx status code
func (o *ApplyReplicationScalePlanNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this apply replication scale plan not found response a status code equal to that given
func (o *ApplyReplicationScalePlanNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the apply replication scale plan not found response
func (o *ApplyReplicationScalePlanNotFound) Code() int {
	return 404
}

func (o *ApplyReplicationScalePlanNotFound) Error() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanNotFound  %+v", 404, o.Payload)
}

func (o *ApplyReplicationScalePlanNotFound) String() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanNotFound  %+v", 404, o.Payload)
}

func (o *ApplyReplicationScalePlanNotFound) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplyReplicationScalePlanNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplyReplicationScalePlanInternalServerError creates a ApplyReplicationScalePlanInternalServerError with default headers values
func NewApplyReplicationScalePlanInternalServerError() *ApplyReplicationScalePlanInternalServerError {
	return &ApplyReplicationScalePlanInternalServerError{}
}

/*
ApplyReplicationScalePlanInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type ApplyReplicationScalePlanInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this apply replication scale plan internal server error response has a 2xx status code
func (o *ApplyReplicationScalePlanInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this apply replication scale plan internal server error response has a 3xx status code
func (o *ApplyReplicationScalePlanInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this apply replication scale plan internal server error response has a 4xx status code
func (o *ApplyReplicationScalePlanInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this apply replication scale plan internal server error response has a 5xx status code
func (o *ApplyReplicationScalePlanInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this apply replication scale plan internal server error response a status code equal to that given
func (o *ApplyReplicationScalePlanInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the apply replication scale plan internal server error response
func (o *ApplyReplicationScalePlanInternalServerError) Code() int {
	return 500
}

func (o *ApplyReplicationScalePlanInternalServerError) Error() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanInternalServerError  %+v", 500, o.Payload)
}

func (o *ApplyReplicationScalePlanInternalServerError) String() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanInternalServerError  %+v", 500, o.Payload)
}

func (o *ApplyReplicationScalePlanInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplyReplicationScalePlanInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplyReplicationScalePlanNotImplemented creates a ApplyReplicationScalePlanNotImplemented with default headers values
func NewApplyReplicationScalePlanNotImplemented() *ApplyReplicationScalePlanNotImplemented {
	return &ApplyReplicationScalePlanNotImplemented{}
}

/*
ApplyReplicationScalePlanNotImplemented describes a response with status code 501, with default header values.

Replica movement operations are disabled.
*/
type ApplyReplicationScalePlanNotImplemented struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this apply replication scale plan not implemented response has a 2xx status code
func (o *ApplyReplicationScalePlanNotImplemented) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this apply replication scale plan not implemented response has a 3xx status code
func (o *ApplyReplicationScalePlanNotImplemented) IsRedirect() bool {
	return false
}

// IsClientError returns true when this apply replication scale plan not implemented response has a 4xx status code
func (o *ApplyReplicationScalePlanNotImplemented) IsClientError() bool {
	return false
}

// IsServerError returns true when this apply replication scale plan not implemented response has a 5xx status code
func (o *ApplyReplicationScalePlanNotImplemented) IsServerError() bool {
	return true
}

// IsCode returns true when this apply replication scale plan not implemented response a status code equal to that given
func (o *ApplyReplicationScalePlanNotImplemented) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the apply replication scale plan not implemented response
func (o *ApplyReplicationScalePlanNotImplemented) Code() int {
	return 501
}

func (o *ApplyReplicationScalePlanNotImplemented) Error() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanNotImplemented  %+v", 501, o.Payload)
}

func (o *ApplyReplicationScalePlanNotImplemented) String() string {
	return fmt.Sprintf("[POST /replication/scale][%d] applyReplicationScalePlanNotImplemented  %+v", 501, o.Payload)
}

func (o *ApplyReplicationScalePlanNotImplemented) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplyReplicationScalePlanNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
