//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewCancelReplicationParams creates a new CancelReplicationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCancelReplicationParams() *CancelReplicationParams {
	return &CancelReplicationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCancelReplicationParamsWithTimeout creates a new CancelReplicationParams object
// with the ability to set a timeout on a request.
func NewCancelReplicationParamsWithTimeout(timeout time.Duration) *CancelReplicationParams {
	return &CancelReplicationParams{
		timeout: timeout,
	}
}

// NewCancelReplicationParamsWithContext creates a new CancelReplicationParams object
// with the ability to set a context for a request.
func NewCancelReplicationParamsWithContext(ctx context.Context) *CancelReplicationParams {
	return &CancelReplicationParams{
		Context: ctx,
	}
}

// NewCancelReplicationParamsWithHTTPClient creates a new CancelReplicationParams object
// with the ability to set a custom HTTPClient for a request.
func NewCancelReplicationParamsWithHTTPClient(client *http.Client) *CancelReplicationParams {
	return &CancelReplicationParams{
		HTTPClient: client,
	}
}

/*
CancelReplicationParams contains all the parameters to send to the API endpoint

	for the cancel replication operation.

	Typically these are written to a http.Request.
*/
type CancelReplicationParams struct {

	/* ID.

	   The ID of the replication operation to cancel.

	   Format: uuid
	*/
	ID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cancel replication params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CancelReplicationParams) WithDefaults() *CancelReplicationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cancel replication params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CancelReplicationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the cancel replication params
func (o *CancelReplicationParams) WithTimeout(timeout time.Duration) *CancelReplicationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cancel replication params
func (o *CancelReplicationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cancel replication params
func (o *CancelReplicationParams) WithContext(ctx context.Context) *CancelReplicationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cancel replication params
func (o *CancelReplicationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cancel replication params
func (o *CancelReplicationParams) WithHTTPClient(client *http.Client) *CancelReplicationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cancel replication params
func (o *CancelReplicationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the cancel replication params
func (o *CancelReplicationParams) WithID(id strfmt.UUID) *CancelReplicationParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the cancel replication params
func (o *CancelReplicationParams) SetID(id strfmt.UUID) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *CancelReplicationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", o.ID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
