//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeleteReplicationParams creates a new DeleteReplicationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteReplicationParams() *DeleteReplicationParams {
	return &DeleteReplicationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteReplicationParamsWithTimeout creates a new DeleteReplicationParams object
// with the ability to set a timeout on a request.
func NewDeleteReplicationParamsWithTimeout(timeout time.Duration) *DeleteReplicationParams {
	return &DeleteReplicationParams{
		timeout: timeout,
	}
}

// NewDeleteReplicationParamsWithContext creates a new DeleteReplicationParams object
// with the ability to set a context for a request.
func NewDeleteReplicationParamsWithContext(ctx context.Context) *DeleteReplicationParams {
	return &DeleteReplicationParams{
		Context: ctx,
	}
}

// NewDeleteReplicationParamsWithHTTPClient creates a new DeleteReplicationParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteReplicationParamsWithHTTPClient(client *http.Client) *DeleteReplicationParams {
	return &DeleteReplicationParams{
		HTTPClient: client,
	}
}

/*
DeleteReplicationParams contains all the parameters to send to the API endpoint

	for the delete replication operation.

	Typically these are written to a http.Request.
*/
type DeleteReplicationParams struct {

	/* ID.

	   The ID of the replication operation to delete.

	   Format: uuid
	*/
	ID strfmt.UUID

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete replication params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteReplicationParams) WithDefaults() *DeleteReplicationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete replication params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteReplicationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete replication params
func (o *DeleteReplicationParams) WithTimeout(timeout time.Duration) *DeleteReplicationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete replication params
func (o *DeleteReplicationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete replication params
func (o *DeleteReplicationParams) WithContext(ctx context.Context) *DeleteReplicationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete replication params
func (o *DeleteReplicationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete replication params
func (o *DeleteReplicationParams) WithHTTPClient(client *http.Client) *DeleteReplicationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete replication params
func (o *DeleteReplicationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the delete replication params
func (o *DeleteReplicationParams) WithID(id strfmt.UUID) *DeleteReplicationParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the delete replication params
func (o *DeleteReplicationParams) SetID(id strfmt.UUID) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteReplicationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", o.ID.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
