//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// DeleteReplicationReader is a Reader for the DeleteReplication structure.
type DeleteReplicationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteReplicationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewDeleteReplicationNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewDeleteReplicationUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteReplicationForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteReplicationNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewDeleteReplicationConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewDeleteReplicationUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteReplicationInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewDeleteReplicationNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDeleteReplicationNoContent creates a DeleteReplicationNoContent with default headers values
func NewDeleteReplicationNoContent() *DeleteReplicationNoContent {
	return &DeleteReplicationNoContent{}
}

/*
DeleteReplicationNoContent describes a response with status code 204, with default header values.

Successfully deleted.
*/
type DeleteReplicationNoContent struct {
}

// IsSuccess returns true when this delete replication no content response has a 2xx status code
func (o *DeleteReplicationNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete replication no content response has a 3xx status code
func (o *DeleteReplicationNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete replication no content response has a 4xx status code
func (o *DeleteReplicationNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete replication no content response has a 5xx status code
func (o *DeleteReplicationNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this delete replication no content response a status code equal to that given
func (o *DeleteReplicationNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the delete replication no content response
func (o *DeleteReplicationNoContent) Code() int {
	return 204
}

func (o *DeleteReplicationNoContent) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationNoContent ", 204)
}

func (o *DeleteReplicationNoContent) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationNoContent ", 204)
}

func (o *DeleteReplicationNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteReplicationUnauthorized creates a DeleteReplicationUnauthorized with default headers values
func NewDeleteReplicationUnauthorized() *DeleteReplicationUnauthorized {
	return &DeleteReplicationUnauthorized{}
}

/*
DeleteReplicationUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type DeleteReplicationUnauthorized struct {
}

// IsSuccess returns true when this delete replication unauthorized response has a 2xx status code
func (o *DeleteReplicationUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete replication unauthorized response has a 3xx status code
func (o *DeleteReplicationUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete replication unauthorized response has a 4xx status code
func (o *DeleteReplicationUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete replication unauthorized response has a 5xx status code
func (o *DeleteReplicationUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete replication unauthorized response a status code equal to that given
func (o *DeleteReplicationUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete replication unauthorized response
func (o *DeleteReplicationUnauthorized) Code() int {
	return 401
}

func (o *DeleteReplicationUnauthorized) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationUnauthorized ", 401)
}

func (o *DeleteReplicationUnauthorized) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationUnauthorized ", 401)
}

func (o *DeleteReplicationUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteReplicationForbidden creates a DeleteReplicationForbidden with default headers values
func NewDeleteReplicationForbidden() *DeleteReplicationForbidden {
	return &DeleteReplicationForbidden{}
}

/*
DeleteReplicationForbidden describes a response with status code 403, with default header values.

Forbidden.
*/
type DeleteReplicationForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this delete replication forbidden response has a 2xx status code
func (o *DeleteReplicationForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete replication forbidden response has a 3xx status code
func (o *DeleteReplicationForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete replication forbidden response has a 4xx status code
func (o *DeleteReplicationForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete replication forbidden response has a 5xx status code
func (o *DeleteReplicationForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete replication forbidden response a status code equal to that given
func (o *DeleteReplicationForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete replication forbidden response
func (o *DeleteReplicationForbidden) Code() int {
	return 403
}

func (o *DeleteReplicationForbidden) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationForbidden  %+v", 403, o.Payload)
}

func (o *DeleteReplicationForbidden) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationForbidden  %+v", 403, o.Payload)
}

func (o *DeleteReplicationForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeleteReplicationForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteReplicationNotFound creates a DeleteReplicationNotFound with default headers values
func NewDeleteReplicationNotFound() *DeleteReplicationNotFound {
	return &DeleteReplicationNotFound{}
}

/*
DeleteReplicationNotFound describes a response with status code 404, with default header values.

Shard replica operation not found.
*/
type DeleteReplicationNotFound struct {
}

// IsSuccess returns true when this delete replication not found response has a 2xx status code
func (o *DeleteReplicationNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete replication not found response has a 3xx status code
func (o *DeleteReplicationNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete replication not found response has a 4xx status code
func (o *DeleteReplicationNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete replication not found response has a 5xx status code
func (o *DeleteReplicationNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete replication not found response a status code equal to that given
func (o *DeleteReplicationNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete replication not found response
func (o *DeleteReplicationNotFound) Code() int {
	return 404
}

func (o *DeleteReplicationNotFound) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationNotFound ", 404)
}

func (o *DeleteReplicationNotFound) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationNotFound ", 404)
}

func (o *DeleteReplicationNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteReplicationConflict creates a DeleteReplicationConflict with default headers values
func NewDeleteReplicationConflict() *DeleteReplicationConflict {
	return &DeleteReplicationConflict{}
}

/*
DeleteReplicationConflict describes a response with status code 409, with default header values.

The operation is not in a deletable state, e.g. it is a MOVE op in the DEHYDRATING state.
*/
type DeleteReplicationConflict struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this delete replication conflict response has a 2xx status code
func (o *DeleteReplicationConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete replication conflict response has a 3xx status code
func (o *DeleteReplicationConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete replication conflict response has a 4xx status code
func (o *DeleteReplicationConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete replication conflict response has a 5xx status code
func (o *DeleteReplicationConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this delete replication conflict response a status code equal to that given
func (o *DeleteReplicationConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the delete replication conflict response
func (o *DeleteReplicationConflict) Code() int {
	return 409
}

func (o *DeleteReplicationConflict) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationConflict  %+v", 409, o.Payload)
}

func (o *DeleteReplicationConflict) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationConflict  %+v", 409, o.Payload)
}

func (o *DeleteReplicationConflict) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeleteReplicationConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteReplicationUnprocessableEntity creates a DeleteReplicationUnprocessableEntity with default headers values
func NewDeleteReplicationUnprocessableEntity() *DeleteReplicationUnprocessableEntity {
	return &DeleteReplicationUnprocessableEntity{}
}

/*
DeleteReplicationUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.
*/
type DeleteReplicationUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this delete replication unprocessable entity response has a 2xx status code
func (o *DeleteReplicationUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete replication unprocessable entity response has a 3xx status code
func (o *DeleteReplicationUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete replication unprocessable entity response has a 4xx status code
func (o *DeleteReplicationUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete replication unprocessable entity response has a 5xx status code
func (o *DeleteReplicationUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this delete replication unprocessable entity response a status code equal to that given
func (o *DeleteReplicationUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the delete replication unprocessable entity response
func (o *DeleteReplicationUnprocessableEntity) Code() int {
	return 422
}

func (o *DeleteReplicationUnprocessableEntity) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *DeleteReplicationUnprocessableEntity) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *DeleteReplicationUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeleteReplicationUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteReplicationInternalServerError creates a DeleteReplicationInternalServerError with default headers values
func NewDeleteReplicationInternalServerError() *DeleteReplicationInternalServerError {
	return &DeleteReplicationInternalServerError{}
}

/*
DeleteReplicationInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type DeleteReplicationInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this delete replication internal server error response has a 2xx status code
func (o *DeleteReplicationInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete replication internal server error response has a 3xx status code
func (o *DeleteReplicationInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete replication internal server error response has a 4xx status code
func (o *DeleteReplicationInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete replication internal server error response has a 5xx status code
func (o *DeleteReplicationInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete replication internal server error response a status code equal to that given
func (o *DeleteReplicationInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete replication internal server error response
func (o *DeleteReplicationInternalServerError) Code() int {
	return 500
}

func (o *DeleteReplicationInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteReplicationInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteReplicationInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeleteReplicationInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteReplicationNotImplemented creates a DeleteReplicationNotImplemented with default headers values
func NewDeleteReplicationNotImplemented() *DeleteReplicationNotImplemented {
	return &DeleteReplicationNotImplemented{}
}

/*
DeleteReplicationNotImplemented describes a response with status code 501, with default header values.

Replica movement operations are disabled.
*/
type DeleteReplicationNotImplemented struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this delete replication not implemented response has a 2xx status code
func (o *DeleteReplicationNotImplemented) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete replication not implemented response has a 3xx status code
func (o *DeleteReplicationNotImplemented) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete replication not implemented response has a 4xx status code
func (o *DeleteReplicationNotImplemented) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete replication not implemented response has a 5xx status code
func (o *DeleteReplicationNotImplemented) IsServerError() bool {
	return true
}

// IsCode returns true when this delete replication not implemented response a status code equal to that given
func (o *DeleteReplicationNotImplemented) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the delete replication not implemented response
func (o *DeleteReplicationNotImplemented) Code() int {
	return 501
}

func (o *DeleteReplicationNotImplemented) Error() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationNotImplemented  %+v", 501, o.Payload)
}

func (o *DeleteReplicationNotImplemented) String() string {
	return fmt.Sprintf("[DELETE /replication/replicate/{id}][%d] deleteReplicationNotImplemented  %+v", 501, o.Payload)
}

func (o *DeleteReplicationNotImplemented) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeleteReplicationNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
