//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetCollectionShardingStateParams creates a new GetCollectionShardingStateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetCollectionShardingStateParams() *GetCollectionShardingStateParams {
	return &GetCollectionShardingStateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetCollectionShardingStateParamsWithTimeout creates a new GetCollectionShardingStateParams object
// with the ability to set a timeout on a request.
func NewGetCollectionShardingStateParamsWithTimeout(timeout time.Duration) *GetCollectionShardingStateParams {
	return &GetCollectionShardingStateParams{
		timeout: timeout,
	}
}

// NewGetCollectionShardingStateParamsWithContext creates a new GetCollectionShardingStateParams object
// with the ability to set a context for a request.
func NewGetCollectionShardingStateParamsWithContext(ctx context.Context) *GetCollectionShardingStateParams {
	return &GetCollectionShardingStateParams{
		Context: ctx,
	}
}

// NewGetCollectionShardingStateParamsWithHTTPClient creates a new GetCollectionShardingStateParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetCollectionShardingStateParamsWithHTTPClient(client *http.Client) *GetCollectionShardingStateParams {
	return &GetCollectionShardingStateParams{
		HTTPClient: client,
	}
}

/*
GetCollectionShardingStateParams contains all the parameters to send to the API endpoint

	for the get collection sharding state operation.

	Typically these are written to a http.Request.
*/
type GetCollectionShardingStateParams struct {

	/* Collection.

	   The collection name to get the sharding state for.
	*/
	Collection *string

	/* Shard.

	   The shard to get the sharding state for.
	*/
	Shard *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get collection sharding state params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCollectionShardingStateParams) WithDefaults() *GetCollectionShardingStateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get collection sharding state params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetCollectionShardingStateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get collection sharding state params
func (o *GetCollectionShardingStateParams) WithTimeout(timeout time.Duration) *GetCollectionShardingStateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get collection sharding state params
func (o *GetCollectionShardingStateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get collection sharding state params
func (o *GetCollectionShardingStateParams) WithContext(ctx context.Context) *GetCollectionShardingStateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get collection sharding state params
func (o *GetCollectionShardingStateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get collection sharding state params
func (o *GetCollectionShardingStateParams) WithHTTPClient(client *http.Client) *GetCollectionShardingStateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get collection sharding state params
func (o *GetCollectionShardingStateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCollection adds the collection to the get collection sharding state params
func (o *GetCollectionShardingStateParams) WithCollection(collection *string) *GetCollectionShardingStateParams {
	o.SetCollection(collection)
	return o
}

// SetCollection adds the collection to the get collection sharding state params
func (o *GetCollectionShardingStateParams) SetCollection(collection *string) {
	o.Collection = collection
}

// WithShard adds the shard to the get collection sharding state params
func (o *GetCollectionShardingStateParams) WithShard(shard *string) *GetCollectionShardingStateParams {
	o.SetShard(shard)
	return o
}

// SetShard adds the shard to the get collection sharding state params
func (o *GetCollectionShardingStateParams) SetShard(shard *string) {
	o.Shard = shard
}

// WriteToRequest writes these params to a swagger request
func (o *GetCollectionShardingStateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Collection != nil {

		// query param collection
		var qrCollection string

		if o.Collection != nil {
			qrCollection = *o.Collection
		}
		qCollection := qrCollection
		if qCollection != "" {

			if err := r.SetQueryParam("collection", qCollection); err != nil {
				return err
			}
		}
	}

	if o.Shard != nil {

		// query param shard
		var qrShard string

		if o.Shard != nil {
			qrShard = *o.Shard
		}
		qShard := qrShard
		if qShard != "" {

			if err := r.SetQueryParam("shard", qShard); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
