//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// GetCollectionShardingStateReader is a Reader for the GetCollectionShardingState structure.
type GetCollectionShardingStateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCollectionShardingStateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCollectionShardingStateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetCollectionShardingStateBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetCollectionShardingStateUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCollectionShardingStateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetCollectionShardingStateNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCollectionShardingStateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewGetCollectionShardingStateNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetCollectionShardingStateOK creates a GetCollectionShardingStateOK with default headers values
func NewGetCollectionShardingStateOK() *GetCollectionShardingStateOK {
	return &GetCollectionShardingStateOK{}
}

/*
GetCollectionShardingStateOK describes a response with status code 200, with default header values.

Successfully retrieved sharding state.
*/
type GetCollectionShardingStateOK struct {
	Payload *models.ReplicationShardingStateResponse
}

// IsSuccess returns true when this get collection sharding state o k response has a 2xx status code
func (o *GetCollectionShardingStateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get collection sharding state o k response has a 3xx status code
func (o *GetCollectionShardingStateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get collection sharding state o k response has a 4xx status code
func (o *GetCollectionShardingStateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get collection sharding state o k response has a 5xx status code
func (o *GetCollectionShardingStateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get collection sharding state o k response a status code equal to that given
func (o *GetCollectionShardingStateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get collection sharding state o k response
func (o *GetCollectionShardingStateOK) Code() int {
	return 200
}

func (o *GetCollectionShardingStateOK) Error() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateOK  %+v", 200, o.Payload)
}

func (o *GetCollectionShardingStateOK) String() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateOK  %+v", 200, o.Payload)
}

func (o *GetCollectionShardingStateOK) GetPayload() *models.ReplicationShardingStateResponse {
	return o.Payload
}

func (o *GetCollectionShardingStateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ReplicationShardingStateResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCollectionShardingStateBadRequest creates a GetCollectionShardingStateBadRequest with default headers values
func NewGetCollectionShardingStateBadRequest() *GetCollectionShardingStateBadRequest {
	return &GetCollectionShardingStateBadRequest{}
}

/*
GetCollectionShardingStateBadRequest describes a response with status code 400, with default header values.

Bad request.
*/
type GetCollectionShardingStateBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get collection sharding state bad request response has a 2xx status code
func (o *GetCollectionShardingStateBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get collection sharding state bad request response has a 3xx status code
func (o *GetCollectionShardingStateBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get collection sharding state bad request response has a 4xx status code
func (o *GetCollectionShardingStateBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get collection sharding state bad request response has a 5xx status code
func (o *GetCollectionShardingStateBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get collection sharding state bad request response a status code equal to that given
func (o *GetCollectionShardingStateBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get collection sharding state bad request response
func (o *GetCollectionShardingStateBadRequest) Code() int {
	return 400
}

func (o *GetCollectionShardingStateBadRequest) Error() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateBadRequest  %+v", 400, o.Payload)
}

func (o *GetCollectionShardingStateBadRequest) String() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateBadRequest  %+v", 400, o.Payload)
}

func (o *GetCollectionShardingStateBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetCollectionShardingStateBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCollectionShardingStateUnauthorized creates a GetCollectionShardingStateUnauthorized with default headers values
func NewGetCollectionShardingStateUnauthorized() *GetCollectionShardingStateUnauthorized {
	return &GetCollectionShardingStateUnauthorized{}
}

/*
GetCollectionShardingStateUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type GetCollectionShardingStateUnauthorized struct {
}

// IsSuccess returns true when this get collection sharding state unauthorized response has a 2xx status code
func (o *GetCollectionShardingStateUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get collection sharding state unauthorized response has a 3xx status code
func (o *GetCollectionShardingStateUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get collection sharding state unauthorized response has a 4xx status code
func (o *GetCollectionShardingStateUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get collection sharding state unauthorized response has a 5xx status code
func (o *GetCollectionShardingStateUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get collection sharding state unauthorized response a status code equal to that given
func (o *GetCollectionShardingStateUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get collection sharding state unauthorized response
func (o *GetCollectionShardingStateUnauthorized) Code() int {
	return 401
}

func (o *GetCollectionShardingStateUnauthorized) Error() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateUnauthorized ", 401)
}

func (o *GetCollectionShardingStateUnauthorized) String() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateUnauthorized ", 401)
}

func (o *GetCollectionShardingStateUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetCollectionShardingStateForbidden creates a GetCollectionShardingStateForbidden with default headers values
func NewGetCollectionShardingStateForbidden() *GetCollectionShardingStateForbidden {
	return &GetCollectionShardingStateForbidden{}
}

/*
GetCollectionShardingStateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetCollectionShardingStateForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get collection sharding state forbidden response has a 2xx status code
func (o *GetCollectionShardingStateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get collection sharding state forbidden response has a 3xx status code
func (o *GetCollectionShardingStateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get collection sharding state forbidden response has a 4xx status code
func (o *GetCollectionShardingStateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get collection sharding state forbidden response has a 5xx status code
func (o *GetCollectionShardingStateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get collection sharding state forbidden response a status code equal to that given
func (o *GetCollectionShardingStateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get collection sharding state forbidden response
func (o *GetCollectionShardingStateForbidden) Code() int {
	return 403
}

func (o *GetCollectionShardingStateForbidden) Error() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateForbidden  %+v", 403, o.Payload)
}

func (o *GetCollectionShardingStateForbidden) String() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateForbidden  %+v", 403, o.Payload)
}

func (o *GetCollectionShardingStateForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetCollectionShardingStateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCollectionShardingStateNotFound creates a GetCollectionShardingStateNotFound with default headers values
func NewGetCollectionShardingStateNotFound() *GetCollectionShardingStateNotFound {
	return &GetCollectionShardingStateNotFound{}
}

/*
GetCollectionShardingStateNotFound describes a response with status code 404, with default header values.

Collection or shard not found.
*/
type GetCollectionShardingStateNotFound struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get collection sharding state not found response has a 2xx status code
func (o *GetCollectionShardingStateNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get collection sharding state not found response has a 3xx status code
func (o *GetCollectionShardingStateNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get collection sharding state not found response has a 4xx status code
func (o *GetCollectionShardingStateNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get collection sharding state not found response has a 5xx status code
func (o *GetCollectionShardingStateNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get collection sharding state not found response a status code equal to that given
func (o *GetCollectionShardingStateNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get collection sharding state not found response
func (o *GetCollectionShardingStateNotFound) Code() int {
	return 404
}

func (o *GetCollectionShardingStateNotFound) Error() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateNotFound  %+v", 404, o.Payload)
}

func (o *GetCollectionShardingStateNotFound) String() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateNotFound  %+v", 404, o.Payload)
}

func (o *GetCollectionShardingStateNotFound) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetCollectionShardingStateNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCollectionShardingStateInternalServerError creates a GetCollectionShardingStateInternalServerError with default headers values
func NewGetCollectionShardingStateInternalServerError() *GetCollectionShardingStateInternalServerError {
	return &GetCollectionShardingStateInternalServerError{}
}

/*
GetCollectionShardingStateInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type GetCollectionShardingStateInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get collection sharding state internal server error response has a 2xx status code
func (o *GetCollectionShardingStateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get collection sharding state internal server error response has a 3xx status code
func (o *GetCollectionShardingStateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get collection sharding state internal server error response has a 4xx status code
func (o *GetCollectionShardingStateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get collection sharding state internal server error response has a 5xx status code
func (o *GetCollectionShardingStateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get collection sharding state internal server error response a status code equal to that given
func (o *GetCollectionShardingStateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get collection sharding state internal server error response
func (o *GetCollectionShardingStateInternalServerError) Code() int {
	return 500
}

func (o *GetCollectionShardingStateInternalServerError) Error() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCollectionShardingStateInternalServerError) String() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateInternalServerError  %+v", 500, o.Payload)
}

func (o *GetCollectionShardingStateInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetCollectionShardingStateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCollectionShardingStateNotImplemented creates a GetCollectionShardingStateNotImplemented with default headers values
func NewGetCollectionShardingStateNotImplemented() *GetCollectionShardingStateNotImplemented {
	return &GetCollectionShardingStateNotImplemented{}
}

/*
GetCollectionShardingStateNotImplemented describes a response with status code 501, with default header values.

Replica movement operations are disabled.
*/
type GetCollectionShardingStateNotImplemented struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get collection sharding state not implemented response has a 2xx status code
func (o *GetCollectionShardingStateNotImplemented) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get collection sharding state not implemented response has a 3xx status code
func (o *GetCollectionShardingStateNotImplemented) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get collection sharding state not implemented response has a 4xx status code
func (o *GetCollectionShardingStateNotImplemented) IsClientError() bool {
	return false
}

// IsServerError returns true when this get collection sharding state not implemented response has a 5xx status code
func (o *GetCollectionShardingStateNotImplemented) IsServerError() bool {
	return true
}

// IsCode returns true when this get collection sharding state not implemented response a status code equal to that given
func (o *GetCollectionShardingStateNotImplemented) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the get collection sharding state not implemented response
func (o *GetCollectionShardingStateNotImplemented) Code() int {
	return 501
}

func (o *GetCollectionShardingStateNotImplemented) Error() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateNotImplemented  %+v", 501, o.Payload)
}

func (o *GetCollectionShardingStateNotImplemented) String() string {
	return fmt.Sprintf("[GET /replication/sharding-state][%d] getCollectionShardingStateNotImplemented  %+v", 501, o.Payload)
}

func (o *GetCollectionShardingStateNotImplemented) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetCollectionShardingStateNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
