//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package replication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// ListReplicationReader is a Reader for the ListReplication structure.
type ListReplicationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListReplicationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListReplicationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewListReplicationBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewListReplicationUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewListReplicationForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewListReplicationInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewListReplicationNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewListReplicationOK creates a ListReplicationOK with default headers values
func NewListReplicationOK() *ListReplicationOK {
	return &ListReplicationOK{}
}

/*
ListReplicationOK describes a response with status code 200, with default header values.

The details of the replication operations.
*/
type ListReplicationOK struct {
	Payload []*models.ReplicationReplicateDetailsReplicaResponse
}

// IsSuccess returns true when this list replication o k response has a 2xx status code
func (o *ListReplicationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list replication o k response has a 3xx status code
func (o *ListReplicationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list replication o k response has a 4xx status code
func (o *ListReplicationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list replication o k response has a 5xx status code
func (o *ListReplicationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list replication o k response a status code equal to that given
func (o *ListReplicationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list replication o k response
func (o *ListReplicationOK) Code() int {
	return 200
}

func (o *ListReplicationOK) Error() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationOK  %+v", 200, o.Payload)
}

func (o *ListReplicationOK) String() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationOK  %+v", 200, o.Payload)
}

func (o *ListReplicationOK) GetPayload() []*models.ReplicationReplicateDetailsReplicaResponse {
	return o.Payload
}

func (o *ListReplicationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListReplicationBadRequest creates a ListReplicationBadRequest with default headers values
func NewListReplicationBadRequest() *ListReplicationBadRequest {
	return &ListReplicationBadRequest{}
}

/*
ListReplicationBadRequest describes a response with status code 400, with default header values.

Bad request.
*/
type ListReplicationBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this list replication bad request response has a 2xx status code
func (o *ListReplicationBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list replication bad request response has a 3xx status code
func (o *ListReplicationBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list replication bad request response has a 4xx status code
func (o *ListReplicationBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this list replication bad request response has a 5xx status code
func (o *ListReplicationBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this list replication bad request response a status code equal to that given
func (o *ListReplicationBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the list replication bad request response
func (o *ListReplicationBadRequest) Code() int {
	return 400
}

func (o *ListReplicationBadRequest) Error() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationBadRequest  %+v", 400, o.Payload)
}

func (o *ListReplicationBadRequest) String() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationBadRequest  %+v", 400, o.Payload)
}

func (o *ListReplicationBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ListReplicationBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListReplicationUnauthorized creates a ListReplicationUnauthorized with default headers values
func NewListReplicationUnauthorized() *ListReplicationUnauthorized {
	return &ListReplicationUnauthorized{}
}

/*
ListReplicationUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type ListReplicationUnauthorized struct {
}

// IsSuccess returns true when this list replication unauthorized response has a 2xx status code
func (o *ListReplicationUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list replication unauthorized response has a 3xx status code
func (o *ListReplicationUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list replication unauthorized response has a 4xx status code
func (o *ListReplicationUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this list replication unauthorized response has a 5xx status code
func (o *ListReplicationUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this list replication unauthorized response a status code equal to that given
func (o *ListReplicationUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the list replication unauthorized response
func (o *ListReplicationUnauthorized) Code() int {
	return 401
}

func (o *ListReplicationUnauthorized) Error() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationUnauthorized ", 401)
}

func (o *ListReplicationUnauthorized) String() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationUnauthorized ", 401)
}

func (o *ListReplicationUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewListReplicationForbidden creates a ListReplicationForbidden with default headers values
func NewListReplicationForbidden() *ListReplicationForbidden {
	return &ListReplicationForbidden{}
}

/*
ListReplicationForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ListReplicationForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this list replication forbidden response has a 2xx status code
func (o *ListReplicationForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list replication forbidden response has a 3xx status code
func (o *ListReplicationForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list replication forbidden response has a 4xx status code
func (o *ListReplicationForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this list replication forbidden response has a 5xx status code
func (o *ListReplicationForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this list replication forbidden response a status code equal to that given
func (o *ListReplicationForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the list replication forbidden response
func (o *ListReplicationForbidden) Code() int {
	return 403
}

func (o *ListReplicationForbidden) Error() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationForbidden  %+v", 403, o.Payload)
}

func (o *ListReplicationForbidden) String() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationForbidden  %+v", 403, o.Payload)
}

func (o *ListReplicationForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ListReplicationForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListReplicationInternalServerError creates a ListReplicationInternalServerError with default headers values
func NewListReplicationInternalServerError() *ListReplicationInternalServerError {
	return &ListReplicationInternalServerError{}
}

/*
ListReplicationInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type ListReplicationInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this list replication internal server error response has a 2xx status code
func (o *ListReplicationInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list replication internal server error response has a 3xx status code
func (o *ListReplicationInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list replication internal server error response has a 4xx status code
func (o *ListReplicationInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this list replication internal server error response has a 5xx status code
func (o *ListReplicationInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this list replication internal server error response a status code equal to that given
func (o *ListReplicationInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the list replication internal server error response
func (o *ListReplicationInternalServerError) Code() int {
	return 500
}

func (o *ListReplicationInternalServerError) Error() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationInternalServerError  %+v", 500, o.Payload)
}

func (o *ListReplicationInternalServerError) String() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationInternalServerError  %+v", 500, o.Payload)
}

func (o *ListReplicationInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ListReplicationInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListReplicationNotImplemented creates a ListReplicationNotImplemented with default headers values
func NewListReplicationNotImplemented() *ListReplicationNotImplemented {
	return &ListReplicationNotImplemented{}
}

/*
ListReplicationNotImplemented describes a response with status code 501, with default header values.

Replica movement operations are disabled.
*/
type ListReplicationNotImplemented struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this list replication not implemented response has a 2xx status code
func (o *ListReplicationNotImplemented) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list replication not implemented response has a 3xx status code
func (o *ListReplicationNotImplemented) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list replication not implemented response has a 4xx status code
func (o *ListReplicationNotImplemented) IsClientError() bool {
	return false
}

// IsServerError returns true when this list replication not implemented response has a 5xx status code
func (o *ListReplicationNotImplemented) IsServerError() bool {
	return true
}

// IsCode returns true when this list replication not implemented response a status code equal to that given
func (o *ListReplicationNotImplemented) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the list replication not implemented response
func (o *ListReplicationNotImplemented) Code() int {
	return 501
}

func (o *ListReplicationNotImplemented) Error() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationNotImplemented  %+v", 501, o.Payload)
}

func (o *ListReplicationNotImplemented) String() string {
	return fmt.Sprintf("[GET /replication/replicate/list][%d] listReplicationNotImplemented  %+v", 501, o.Payload)
}

func (o *ListReplicationNotImplemented) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ListReplicationNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
