//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesCreateReader is a Reader for the AliasesCreate structure.
type AliasesCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AliasesCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAliasesCreateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewAliasesCreateUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAliasesCreateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewAliasesCreateUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAliasesCreateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewAliasesCreateOK creates a AliasesCreateOK with default headers values
func NewAliasesCreateOK() *AliasesCreateOK {
	return &AliasesCreateOK{}
}

/*
AliasesCreateOK describes a response with status code 200, with default header values.

Successfully created a new alias for the specified collection (class)
*/
type AliasesCreateOK struct {
	Payload *models.Alias
}

// IsSuccess returns true when this aliases create o k response has a 2xx status code
func (o *AliasesCreateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aliases create o k response has a 3xx status code
func (o *AliasesCreateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases create o k response has a 4xx status code
func (o *AliasesCreateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aliases create o k response has a 5xx status code
func (o *AliasesCreateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases create o k response a status code equal to that given
func (o *AliasesCreateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aliases create o k response
func (o *AliasesCreateOK) Code() int {
	return 200
}

func (o *AliasesCreateOK) Error() string {
	return fmt.Sprintf("[POST /aliases][%d] aliasesCreateOK  %+v", 200, o.Payload)
}

func (o *AliasesCreateOK) String() string {
	return fmt.Sprintf("[POST /aliases][%d] aliasesCreateOK  %+v", 200, o.Payload)
}

func (o *AliasesCreateOK) GetPayload() *models.Alias {
	return o.Payload
}

func (o *AliasesCreateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Alias)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesCreateUnauthorized creates a AliasesCreateUnauthorized with default headers values
func NewAliasesCreateUnauthorized() *AliasesCreateUnauthorized {
	return &AliasesCreateUnauthorized{}
}

/*
AliasesCreateUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type AliasesCreateUnauthorized struct {
}

// IsSuccess returns true when this aliases create unauthorized response has a 2xx status code
func (o *AliasesCreateUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases create unauthorized response has a 3xx status code
func (o *AliasesCreateUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases create unauthorized response has a 4xx status code
func (o *AliasesCreateUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases create unauthorized response has a 5xx status code
func (o *AliasesCreateUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases create unauthorized response a status code equal to that given
func (o *AliasesCreateUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the aliases create unauthorized response
func (o *AliasesCreateUnauthorized) Code() int {
	return 401
}

func (o *AliasesCreateUnauthorized) Error() string {
	return fmt.Sprintf("[POST /aliases][%d] aliasesCreateUnauthorized ", 401)
}

func (o *AliasesCreateUnauthorized) String() string {
	return fmt.Sprintf("[POST /aliases][%d] aliasesCreateUnauthorized ", 401)
}

func (o *AliasesCreateUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAliasesCreateForbidden creates a AliasesCreateForbidden with default headers values
func NewAliasesCreateForbidden() *AliasesCreateForbidden {
	return &AliasesCreateForbidden{}
}

/*
AliasesCreateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AliasesCreateForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases create forbidden response has a 2xx status code
func (o *AliasesCreateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases create forbidden response has a 3xx status code
func (o *AliasesCreateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases create forbidden response has a 4xx status code
func (o *AliasesCreateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases create forbidden response has a 5xx status code
func (o *AliasesCreateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases create forbidden response a status code equal to that given
func (o *AliasesCreateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the aliases create forbidden response
func (o *AliasesCreateForbidden) Code() int {
	return 403
}

func (o *AliasesCreateForbidden) Error() string {
	return fmt.Sprintf("[POST /aliases][%d] aliasesCreateForbidden  %+v", 403, o.Payload)
}

func (o *AliasesCreateForbidden) String() string {
	return fmt.Sprintf("[POST /aliases][%d] aliasesCreateForbidden  %+v", 403, o.Payload)
}

func (o *AliasesCreateForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesCreateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesCreateUnprocessableEntity creates a AliasesCreateUnprocessableEntity with default headers values
func NewAliasesCreateUnprocessableEntity() *AliasesCreateUnprocessableEntity {
	return &AliasesCreateUnprocessableEntity{}
}

/*
AliasesCreateUnprocessableEntity describes a response with status code 422, with default header values.

Invalid create alias request.
*/
type AliasesCreateUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases create unprocessable entity response has a 2xx status code
func (o *AliasesCreateUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases create unprocessable entity response has a 3xx status code
func (o *AliasesCreateUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases create unprocessable entity response has a 4xx status code
func (o *AliasesCreateUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases create unprocessable entity response has a 5xx status code
func (o *AliasesCreateUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases create unprocessable entity response a status code equal to that given
func (o *AliasesCreateUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the aliases create unprocessable entity response
func (o *AliasesCreateUnprocessableEntity) Code() int {
	return 422
}

func (o *AliasesCreateUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /aliases][%d] aliasesCreateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AliasesCreateUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /aliases][%d] aliasesCreateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AliasesCreateUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesCreateUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesCreateInternalServerError creates a AliasesCreateInternalServerError with default headers values
func NewAliasesCreateInternalServerError() *AliasesCreateInternalServerError {
	return &AliasesCreateInternalServerError{}
}

/*
AliasesCreateInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type AliasesCreateInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases create internal server error response has a 2xx status code
func (o *AliasesCreateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases create internal server error response has a 3xx status code
func (o *AliasesCreateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases create internal server error response has a 4xx status code
func (o *AliasesCreateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this aliases create internal server error response has a 5xx status code
func (o *AliasesCreateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this aliases create internal server error response a status code equal to that given
func (o *AliasesCreateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the aliases create internal server error response
func (o *AliasesCreateInternalServerError) Code() int {
	return 500
}

func (o *AliasesCreateInternalServerError) Error() string {
	return fmt.Sprintf("[POST /aliases][%d] aliasesCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *AliasesCreateInternalServerError) String() string {
	return fmt.Sprintf("[POST /aliases][%d] aliasesCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *AliasesCreateInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesCreateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
