//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesDeleteReader is a Reader for the AliasesDelete structure.
type AliasesDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AliasesDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewAliasesDeleteNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewAliasesDeleteUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAliasesDeleteForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewAliasesDeleteNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewAliasesDeleteUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAliasesDeleteInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewAliasesDeleteNoContent creates a AliasesDeleteNoContent with default headers values
func NewAliasesDeleteNoContent() *AliasesDeleteNoContent {
	return &AliasesDeleteNoContent{}
}

/*
AliasesDeleteNoContent describes a response with status code 204, with default header values.

Successfully deleted the alias.
*/
type AliasesDeleteNoContent struct {
}

// IsSuccess returns true when this aliases delete no content response has a 2xx status code
func (o *AliasesDeleteNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aliases delete no content response has a 3xx status code
func (o *AliasesDeleteNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases delete no content response has a 4xx status code
func (o *AliasesDeleteNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this aliases delete no content response has a 5xx status code
func (o *AliasesDeleteNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases delete no content response a status code equal to that given
func (o *AliasesDeleteNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the aliases delete no content response
func (o *AliasesDeleteNoContent) Code() int {
	return 204
}

func (o *AliasesDeleteNoContent) Error() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteNoContent ", 204)
}

func (o *AliasesDeleteNoContent) String() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteNoContent ", 204)
}

func (o *AliasesDeleteNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAliasesDeleteUnauthorized creates a AliasesDeleteUnauthorized with default headers values
func NewAliasesDeleteUnauthorized() *AliasesDeleteUnauthorized {
	return &AliasesDeleteUnauthorized{}
}

/*
AliasesDeleteUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type AliasesDeleteUnauthorized struct {
}

// IsSuccess returns true when this aliases delete unauthorized response has a 2xx status code
func (o *AliasesDeleteUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases delete unauthorized response has a 3xx status code
func (o *AliasesDeleteUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases delete unauthorized response has a 4xx status code
func (o *AliasesDeleteUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases delete unauthorized response has a 5xx status code
func (o *AliasesDeleteUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases delete unauthorized response a status code equal to that given
func (o *AliasesDeleteUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the aliases delete unauthorized response
func (o *AliasesDeleteUnauthorized) Code() int {
	return 401
}

func (o *AliasesDeleteUnauthorized) Error() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteUnauthorized ", 401)
}

func (o *AliasesDeleteUnauthorized) String() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteUnauthorized ", 401)
}

func (o *AliasesDeleteUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAliasesDeleteForbidden creates a AliasesDeleteForbidden with default headers values
func NewAliasesDeleteForbidden() *AliasesDeleteForbidden {
	return &AliasesDeleteForbidden{}
}

/*
AliasesDeleteForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AliasesDeleteForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases delete forbidden response has a 2xx status code
func (o *AliasesDeleteForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases delete forbidden response has a 3xx status code
func (o *AliasesDeleteForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases delete forbidden response has a 4xx status code
func (o *AliasesDeleteForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases delete forbidden response has a 5xx status code
func (o *AliasesDeleteForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases delete forbidden response a status code equal to that given
func (o *AliasesDeleteForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the aliases delete forbidden response
func (o *AliasesDeleteForbidden) Code() int {
	return 403
}

func (o *AliasesDeleteForbidden) Error() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteForbidden  %+v", 403, o.Payload)
}

func (o *AliasesDeleteForbidden) String() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteForbidden  %+v", 403, o.Payload)
}

func (o *AliasesDeleteForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesDeleteForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesDeleteNotFound creates a AliasesDeleteNotFound with default headers values
func NewAliasesDeleteNotFound() *AliasesDeleteNotFound {
	return &AliasesDeleteNotFound{}
}

/*
AliasesDeleteNotFound describes a response with status code 404, with default header values.

Not Found - Alias does not exist
*/
type AliasesDeleteNotFound struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases delete not found response has a 2xx status code
func (o *AliasesDeleteNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases delete not found response has a 3xx status code
func (o *AliasesDeleteNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases delete not found response has a 4xx status code
func (o *AliasesDeleteNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases delete not found response has a 5xx status code
func (o *AliasesDeleteNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases delete not found response a status code equal to that given
func (o *AliasesDeleteNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the aliases delete not found response
func (o *AliasesDeleteNotFound) Code() int {
	return 404
}

func (o *AliasesDeleteNotFound) Error() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteNotFound  %+v", 404, o.Payload)
}

func (o *AliasesDeleteNotFound) String() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteNotFound  %+v", 404, o.Payload)
}

func (o *AliasesDeleteNotFound) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesDeleteNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesDeleteUnprocessableEntity creates a AliasesDeleteUnprocessableEntity with default headers values
func NewAliasesDeleteUnprocessableEntity() *AliasesDeleteUnprocessableEntity {
	return &AliasesDeleteUnprocessableEntity{}
}

/*
AliasesDeleteUnprocessableEntity describes a response with status code 422, with default header values.

Invalid delete alias request.
*/
type AliasesDeleteUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases delete unprocessable entity response has a 2xx status code
func (o *AliasesDeleteUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases delete unprocessable entity response has a 3xx status code
func (o *AliasesDeleteUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases delete unprocessable entity response has a 4xx status code
func (o *AliasesDeleteUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases delete unprocessable entity response has a 5xx status code
func (o *AliasesDeleteUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases delete unprocessable entity response a status code equal to that given
func (o *AliasesDeleteUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the aliases delete unprocessable entity response
func (o *AliasesDeleteUnprocessableEntity) Code() int {
	return 422
}

func (o *AliasesDeleteUnprocessableEntity) Error() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AliasesDeleteUnprocessableEntity) String() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AliasesDeleteUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesDeleteUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesDeleteInternalServerError creates a AliasesDeleteInternalServerError with default headers values
func NewAliasesDeleteInternalServerError() *AliasesDeleteInternalServerError {
	return &AliasesDeleteInternalServerError{}
}

/*
AliasesDeleteInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type AliasesDeleteInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases delete internal server error response has a 2xx status code
func (o *AliasesDeleteInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases delete internal server error response has a 3xx status code
func (o *AliasesDeleteInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases delete internal server error response has a 4xx status code
func (o *AliasesDeleteInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this aliases delete internal server error response has a 5xx status code
func (o *AliasesDeleteInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this aliases delete internal server error response a status code equal to that given
func (o *AliasesDeleteInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the aliases delete internal server error response
func (o *AliasesDeleteInternalServerError) Code() int {
	return 500
}

func (o *AliasesDeleteInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *AliasesDeleteInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /aliases/{aliasName}][%d] aliasesDeleteInternalServerError  %+v", 500, o.Payload)
}

func (o *AliasesDeleteInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesDeleteInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
