//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesGetAliasReader is a Reader for the AliasesGetAlias structure.
type AliasesGetAliasReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AliasesGetAliasReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAliasesGetAliasOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewAliasesGetAliasUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAliasesGetAliasForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewAliasesGetAliasNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewAliasesGetAliasUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAliasesGetAliasInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewAliasesGetAliasOK creates a AliasesGetAliasOK with default headers values
func NewAliasesGetAliasOK() *AliasesGetAliasOK {
	return &AliasesGetAliasOK{}
}

/*
AliasesGetAliasOK describes a response with status code 200, with default header values.

Successfully retrieved the alias details.
*/
type AliasesGetAliasOK struct {
	Payload *models.Alias
}

// IsSuccess returns true when this aliases get alias o k response has a 2xx status code
func (o *AliasesGetAliasOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aliases get alias o k response has a 3xx status code
func (o *AliasesGetAliasOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases get alias o k response has a 4xx status code
func (o *AliasesGetAliasOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aliases get alias o k response has a 5xx status code
func (o *AliasesGetAliasOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases get alias o k response a status code equal to that given
func (o *AliasesGetAliasOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aliases get alias o k response
func (o *AliasesGetAliasOK) Code() int {
	return 200
}

func (o *AliasesGetAliasOK) Error() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasOK  %+v", 200, o.Payload)
}

func (o *AliasesGetAliasOK) String() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasOK  %+v", 200, o.Payload)
}

func (o *AliasesGetAliasOK) GetPayload() *models.Alias {
	return o.Payload
}

func (o *AliasesGetAliasOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Alias)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesGetAliasUnauthorized creates a AliasesGetAliasUnauthorized with default headers values
func NewAliasesGetAliasUnauthorized() *AliasesGetAliasUnauthorized {
	return &AliasesGetAliasUnauthorized{}
}

/*
AliasesGetAliasUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type AliasesGetAliasUnauthorized struct {
}

// IsSuccess returns true when this aliases get alias unauthorized response has a 2xx status code
func (o *AliasesGetAliasUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases get alias unauthorized response has a 3xx status code
func (o *AliasesGetAliasUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases get alias unauthorized response has a 4xx status code
func (o *AliasesGetAliasUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases get alias unauthorized response has a 5xx status code
func (o *AliasesGetAliasUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases get alias unauthorized response a status code equal to that given
func (o *AliasesGetAliasUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the aliases get alias unauthorized response
func (o *AliasesGetAliasUnauthorized) Code() int {
	return 401
}

func (o *AliasesGetAliasUnauthorized) Error() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasUnauthorized ", 401)
}

func (o *AliasesGetAliasUnauthorized) String() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasUnauthorized ", 401)
}

func (o *AliasesGetAliasUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAliasesGetAliasForbidden creates a AliasesGetAliasForbidden with default headers values
func NewAliasesGetAliasForbidden() *AliasesGetAliasForbidden {
	return &AliasesGetAliasForbidden{}
}

/*
AliasesGetAliasForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AliasesGetAliasForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases get alias forbidden response has a 2xx status code
func (o *AliasesGetAliasForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases get alias forbidden response has a 3xx status code
func (o *AliasesGetAliasForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases get alias forbidden response has a 4xx status code
func (o *AliasesGetAliasForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases get alias forbidden response has a 5xx status code
func (o *AliasesGetAliasForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases get alias forbidden response a status code equal to that given
func (o *AliasesGetAliasForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the aliases get alias forbidden response
func (o *AliasesGetAliasForbidden) Code() int {
	return 403
}

func (o *AliasesGetAliasForbidden) Error() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasForbidden  %+v", 403, o.Payload)
}

func (o *AliasesGetAliasForbidden) String() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasForbidden  %+v", 403, o.Payload)
}

func (o *AliasesGetAliasForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesGetAliasForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesGetAliasNotFound creates a AliasesGetAliasNotFound with default headers values
func NewAliasesGetAliasNotFound() *AliasesGetAliasNotFound {
	return &AliasesGetAliasNotFound{}
}

/*
AliasesGetAliasNotFound describes a response with status code 404, with default header values.

Not Found - Alias does not exist
*/
type AliasesGetAliasNotFound struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases get alias not found response has a 2xx status code
func (o *AliasesGetAliasNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases get alias not found response has a 3xx status code
func (o *AliasesGetAliasNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases get alias not found response has a 4xx status code
func (o *AliasesGetAliasNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases get alias not found response has a 5xx status code
func (o *AliasesGetAliasNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases get alias not found response a status code equal to that given
func (o *AliasesGetAliasNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the aliases get alias not found response
func (o *AliasesGetAliasNotFound) Code() int {
	return 404
}

func (o *AliasesGetAliasNotFound) Error() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasNotFound  %+v", 404, o.Payload)
}

func (o *AliasesGetAliasNotFound) String() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasNotFound  %+v", 404, o.Payload)
}

func (o *AliasesGetAliasNotFound) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesGetAliasNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesGetAliasUnprocessableEntity creates a AliasesGetAliasUnprocessableEntity with default headers values
func NewAliasesGetAliasUnprocessableEntity() *AliasesGetAliasUnprocessableEntity {
	return &AliasesGetAliasUnprocessableEntity{}
}

/*
AliasesGetAliasUnprocessableEntity describes a response with status code 422, with default header values.

Invalid alias name provided.
*/
type AliasesGetAliasUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases get alias unprocessable entity response has a 2xx status code
func (o *AliasesGetAliasUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases get alias unprocessable entity response has a 3xx status code
func (o *AliasesGetAliasUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases get alias unprocessable entity response has a 4xx status code
func (o *AliasesGetAliasUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases get alias unprocessable entity response has a 5xx status code
func (o *AliasesGetAliasUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases get alias unprocessable entity response a status code equal to that given
func (o *AliasesGetAliasUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the aliases get alias unprocessable entity response
func (o *AliasesGetAliasUnprocessableEntity) Code() int {
	return 422
}

func (o *AliasesGetAliasUnprocessableEntity) Error() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AliasesGetAliasUnprocessableEntity) String() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AliasesGetAliasUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesGetAliasUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesGetAliasInternalServerError creates a AliasesGetAliasInternalServerError with default headers values
func NewAliasesGetAliasInternalServerError() *AliasesGetAliasInternalServerError {
	return &AliasesGetAliasInternalServerError{}
}

/*
AliasesGetAliasInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type AliasesGetAliasInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases get alias internal server error response has a 2xx status code
func (o *AliasesGetAliasInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases get alias internal server error response has a 3xx status code
func (o *AliasesGetAliasInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases get alias internal server error response has a 4xx status code
func (o *AliasesGetAliasInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this aliases get alias internal server error response has a 5xx status code
func (o *AliasesGetAliasInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this aliases get alias internal server error response a status code equal to that given
func (o *AliasesGetAliasInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the aliases get alias internal server error response
func (o *AliasesGetAliasInternalServerError) Code() int {
	return 500
}

func (o *AliasesGetAliasInternalServerError) Error() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasInternalServerError  %+v", 500, o.Payload)
}

func (o *AliasesGetAliasInternalServerError) String() string {
	return fmt.Sprintf("[GET /aliases/{aliasName}][%d] aliasesGetAliasInternalServerError  %+v", 500, o.Payload)
}

func (o *AliasesGetAliasInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesGetAliasInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
