//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewAliasesGetParams creates a new AliasesGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAliasesGetParams() *AliasesGetParams {
	return &AliasesGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAliasesGetParamsWithTimeout creates a new AliasesGetParams object
// with the ability to set a timeout on a request.
func NewAliasesGetParamsWithTimeout(timeout time.Duration) *AliasesGetParams {
	return &AliasesGetParams{
		timeout: timeout,
	}
}

// NewAliasesGetParamsWithContext creates a new AliasesGetParams object
// with the ability to set a context for a request.
func NewAliasesGetParamsWithContext(ctx context.Context) *AliasesGetParams {
	return &AliasesGetParams{
		Context: ctx,
	}
}

// NewAliasesGetParamsWithHTTPClient creates a new AliasesGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAliasesGetParamsWithHTTPClient(client *http.Client) *AliasesGetParams {
	return &AliasesGetParams{
		HTTPClient: client,
	}
}

/*
AliasesGetParams contains all the parameters to send to the API endpoint

	for the aliases get operation.

	Typically these are written to a http.Request.
*/
type AliasesGetParams struct {

	/* Class.

	   Optional filter to retrieve aliases for a specific collection (class) only. If not provided, returns all aliases.
	*/
	Class *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the aliases get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AliasesGetParams) WithDefaults() *AliasesGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the aliases get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AliasesGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the aliases get params
func (o *AliasesGetParams) WithTimeout(timeout time.Duration) *AliasesGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the aliases get params
func (o *AliasesGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the aliases get params
func (o *AliasesGetParams) WithContext(ctx context.Context) *AliasesGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the aliases get params
func (o *AliasesGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the aliases get params
func (o *AliasesGetParams) WithHTTPClient(client *http.Client) *AliasesGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the aliases get params
func (o *AliasesGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClass adds the class to the aliases get params
func (o *AliasesGetParams) WithClass(class *string) *AliasesGetParams {
	o.SetClass(class)
	return o
}

// SetClass adds the class to the aliases get params
func (o *AliasesGetParams) SetClass(class *string) {
	o.Class = class
}

// WriteToRequest writes these params to a swagger request
func (o *AliasesGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Class != nil {

		// query param class
		var qrClass string

		if o.Class != nil {
			qrClass = *o.Class
		}
		qClass := qrClass
		if qClass != "" {

			if err := r.SetQueryParam("class", qClass); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
