//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// AliasesGetReader is a Reader for the AliasesGet structure.
type AliasesGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AliasesGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAliasesGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewAliasesGetUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAliasesGetForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewAliasesGetUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAliasesGetInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewAliasesGetOK creates a AliasesGetOK with default headers values
func NewAliasesGetOK() *AliasesGetOK {
	return &AliasesGetOK{}
}

/*
AliasesGetOK describes a response with status code 200, with default header values.

Successfully retrieved the list of aliases
*/
type AliasesGetOK struct {
	Payload *models.AliasResponse
}

// IsSuccess returns true when this aliases get o k response has a 2xx status code
func (o *AliasesGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aliases get o k response has a 3xx status code
func (o *AliasesGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases get o k response has a 4xx status code
func (o *AliasesGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aliases get o k response has a 5xx status code
func (o *AliasesGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases get o k response a status code equal to that given
func (o *AliasesGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aliases get o k response
func (o *AliasesGetOK) Code() int {
	return 200
}

func (o *AliasesGetOK) Error() string {
	return fmt.Sprintf("[GET /aliases][%d] aliasesGetOK  %+v", 200, o.Payload)
}

func (o *AliasesGetOK) String() string {
	return fmt.Sprintf("[GET /aliases][%d] aliasesGetOK  %+v", 200, o.Payload)
}

func (o *AliasesGetOK) GetPayload() *models.AliasResponse {
	return o.Payload
}

func (o *AliasesGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AliasResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesGetUnauthorized creates a AliasesGetUnauthorized with default headers values
func NewAliasesGetUnauthorized() *AliasesGetUnauthorized {
	return &AliasesGetUnauthorized{}
}

/*
AliasesGetUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type AliasesGetUnauthorized struct {
}

// IsSuccess returns true when this aliases get unauthorized response has a 2xx status code
func (o *AliasesGetUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases get unauthorized response has a 3xx status code
func (o *AliasesGetUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases get unauthorized response has a 4xx status code
func (o *AliasesGetUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases get unauthorized response has a 5xx status code
func (o *AliasesGetUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases get unauthorized response a status code equal to that given
func (o *AliasesGetUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the aliases get unauthorized response
func (o *AliasesGetUnauthorized) Code() int {
	return 401
}

func (o *AliasesGetUnauthorized) Error() string {
	return fmt.Sprintf("[GET /aliases][%d] aliasesGetUnauthorized ", 401)
}

func (o *AliasesGetUnauthorized) String() string {
	return fmt.Sprintf("[GET /aliases][%d] aliasesGetUnauthorized ", 401)
}

func (o *AliasesGetUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewAliasesGetForbidden creates a AliasesGetForbidden with default headers values
func NewAliasesGetForbidden() *AliasesGetForbidden {
	return &AliasesGetForbidden{}
}

/*
AliasesGetForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type AliasesGetForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases get forbidden response has a 2xx status code
func (o *AliasesGetForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases get forbidden response has a 3xx status code
func (o *AliasesGetForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases get forbidden response has a 4xx status code
func (o *AliasesGetForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases get forbidden response has a 5xx status code
func (o *AliasesGetForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases get forbidden response a status code equal to that given
func (o *AliasesGetForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the aliases get forbidden response
func (o *AliasesGetForbidden) Code() int {
	return 403
}

func (o *AliasesGetForbidden) Error() string {
	return fmt.Sprintf("[GET /aliases][%d] aliasesGetForbidden  %+v", 403, o.Payload)
}

func (o *AliasesGetForbidden) String() string {
	return fmt.Sprintf("[GET /aliases][%d] aliasesGetForbidden  %+v", 403, o.Payload)
}

func (o *AliasesGetForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesGetForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesGetUnprocessableEntity creates a AliasesGetUnprocessableEntity with default headers values
func NewAliasesGetUnprocessableEntity() *AliasesGetUnprocessableEntity {
	return &AliasesGetUnprocessableEntity{}
}

/*
AliasesGetUnprocessableEntity describes a response with status code 422, with default header values.

Invalid collection (class) parameter provided
*/
type AliasesGetUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases get unprocessable entity response has a 2xx status code
func (o *AliasesGetUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases get unprocessable entity response has a 3xx status code
func (o *AliasesGetUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases get unprocessable entity response has a 4xx status code
func (o *AliasesGetUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this aliases get unprocessable entity response has a 5xx status code
func (o *AliasesGetUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this aliases get unprocessable entity response a status code equal to that given
func (o *AliasesGetUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the aliases get unprocessable entity response
func (o *AliasesGetUnprocessableEntity) Code() int {
	return 422
}

func (o *AliasesGetUnprocessableEntity) Error() string {
	return fmt.Sprintf("[GET /aliases][%d] aliasesGetUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AliasesGetUnprocessableEntity) String() string {
	return fmt.Sprintf("[GET /aliases][%d] aliasesGetUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *AliasesGetUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesGetUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAliasesGetInternalServerError creates a AliasesGetInternalServerError with default headers values
func NewAliasesGetInternalServerError() *AliasesGetInternalServerError {
	return &AliasesGetInternalServerError{}
}

/*
AliasesGetInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type AliasesGetInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aliases get internal server error response has a 2xx status code
func (o *AliasesGetInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this aliases get internal server error response has a 3xx status code
func (o *AliasesGetInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aliases get internal server error response has a 4xx status code
func (o *AliasesGetInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this aliases get internal server error response has a 5xx status code
func (o *AliasesGetInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this aliases get internal server error response a status code equal to that given
func (o *AliasesGetInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the aliases get internal server error response
func (o *AliasesGetInternalServerError) Code() int {
	return 500
}

func (o *AliasesGetInternalServerError) Error() string {
	return fmt.Sprintf("[GET /aliases][%d] aliasesGetInternalServerError  %+v", 500, o.Payload)
}

func (o *AliasesGetInternalServerError) String() string {
	return fmt.Sprintf("[GET /aliases][%d] aliasesGetInternalServerError  %+v", 500, o.Payload)
}

func (o *AliasesGetInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AliasesGetInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
