//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewAliasesUpdateParams creates a new AliasesUpdateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAliasesUpdateParams() *AliasesUpdateParams {
	return &AliasesUpdateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAliasesUpdateParamsWithTimeout creates a new AliasesUpdateParams object
// with the ability to set a timeout on a request.
func NewAliasesUpdateParamsWithTimeout(timeout time.Duration) *AliasesUpdateParams {
	return &AliasesUpdateParams{
		timeout: timeout,
	}
}

// NewAliasesUpdateParamsWithContext creates a new AliasesUpdateParams object
// with the ability to set a context for a request.
func NewAliasesUpdateParamsWithContext(ctx context.Context) *AliasesUpdateParams {
	return &AliasesUpdateParams{
		Context: ctx,
	}
}

// NewAliasesUpdateParamsWithHTTPClient creates a new AliasesUpdateParams object
// with the ability to set a custom HTTPClient for a request.
func NewAliasesUpdateParamsWithHTTPClient(client *http.Client) *AliasesUpdateParams {
	return &AliasesUpdateParams{
		HTTPClient: client,
	}
}

/*
AliasesUpdateParams contains all the parameters to send to the API endpoint

	for the aliases update operation.

	Typically these are written to a http.Request.
*/
type AliasesUpdateParams struct {

	// AliasName.
	AliasName string

	// Body.
	Body AliasesUpdateBody

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the aliases update params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AliasesUpdateParams) WithDefaults() *AliasesUpdateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the aliases update params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AliasesUpdateParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the aliases update params
func (o *AliasesUpdateParams) WithTimeout(timeout time.Duration) *AliasesUpdateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the aliases update params
func (o *AliasesUpdateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the aliases update params
func (o *AliasesUpdateParams) WithContext(ctx context.Context) *AliasesUpdateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the aliases update params
func (o *AliasesUpdateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the aliases update params
func (o *AliasesUpdateParams) WithHTTPClient(client *http.Client) *AliasesUpdateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the aliases update params
func (o *AliasesUpdateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAliasName adds the aliasName to the aliases update params
func (o *AliasesUpdateParams) WithAliasName(aliasName string) *AliasesUpdateParams {
	o.SetAliasName(aliasName)
	return o
}

// SetAliasName adds the aliasName to the aliases update params
func (o *AliasesUpdateParams) SetAliasName(aliasName string) {
	o.AliasName = aliasName
}

// WithBody adds the body to the aliases update params
func (o *AliasesUpdateParams) WithBody(body AliasesUpdateBody) *AliasesUpdateParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the aliases update params
func (o *AliasesUpdateParams) SetBody(body AliasesUpdateBody) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *AliasesUpdateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param aliasName
	if err := r.SetPathParam("aliasName", o.AliasName); err != nil {
		return err
	}
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
