//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSchemaDumpParams creates a new SchemaDumpParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSchemaDumpParams() *SchemaDumpParams {
	return &SchemaDumpParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSchemaDumpParamsWithTimeout creates a new SchemaDumpParams object
// with the ability to set a timeout on a request.
func NewSchemaDumpParamsWithTimeout(timeout time.Duration) *SchemaDumpParams {
	return &SchemaDumpParams{
		timeout: timeout,
	}
}

// NewSchemaDumpParamsWithContext creates a new SchemaDumpParams object
// with the ability to set a context for a request.
func NewSchemaDumpParamsWithContext(ctx context.Context) *SchemaDumpParams {
	return &SchemaDumpParams{
		Context: ctx,
	}
}

// NewSchemaDumpParamsWithHTTPClient creates a new SchemaDumpParams object
// with the ability to set a custom HTTPClient for a request.
func NewSchemaDumpParamsWithHTTPClient(client *http.Client) *SchemaDumpParams {
	return &SchemaDumpParams{
		HTTPClient: client,
	}
}

/*
SchemaDumpParams contains all the parameters to send to the API endpoint

	for the schema dump operation.

	Typically these are written to a http.Request.
*/
type SchemaDumpParams struct {

	/* Consistency.

	   If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.

	   Default: true
	*/
	Consistency *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the schema dump params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SchemaDumpParams) WithDefaults() *SchemaDumpParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the schema dump params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SchemaDumpParams) SetDefaults() {
	var (
		consistencyDefault = bool(true)
	)

	val := SchemaDumpParams{
		Consistency: &consistencyDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the schema dump params
func (o *SchemaDumpParams) WithTimeout(timeout time.Duration) *SchemaDumpParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the schema dump params
func (o *SchemaDumpParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the schema dump params
func (o *SchemaDumpParams) WithContext(ctx context.Context) *SchemaDumpParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the schema dump params
func (o *SchemaDumpParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the schema dump params
func (o *SchemaDumpParams) WithHTTPClient(client *http.Client) *SchemaDumpParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the schema dump params
func (o *SchemaDumpParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithConsistency adds the consistency to the schema dump params
func (o *SchemaDumpParams) WithConsistency(consistency *bool) *SchemaDumpParams {
	o.SetConsistency(consistency)
	return o
}

// SetConsistency adds the consistency to the schema dump params
func (o *SchemaDumpParams) SetConsistency(consistency *bool) {
	o.Consistency = consistency
}

// WriteToRequest writes these params to a swagger request
func (o *SchemaDumpParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Consistency != nil {

		// header param consistency
		if err := r.SetHeaderParam("consistency", swag.FormatBool(*o.Consistency)); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
