//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// SchemaObjectsCreateReader is a Reader for the SchemaObjectsCreate structure.
type SchemaObjectsCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SchemaObjectsCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSchemaObjectsCreateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewSchemaObjectsCreateUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSchemaObjectsCreateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewSchemaObjectsCreateUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSchemaObjectsCreateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSchemaObjectsCreateOK creates a SchemaObjectsCreateOK with default headers values
func NewSchemaObjectsCreateOK() *SchemaObjectsCreateOK {
	return &SchemaObjectsCreateOK{}
}

/*
SchemaObjectsCreateOK describes a response with status code 200, with default header values.

Collection created successfully and its definition returned.
*/
type SchemaObjectsCreateOK struct {
	Payload *models.Class
}

// IsSuccess returns true when this schema objects create o k response has a 2xx status code
func (o *SchemaObjectsCreateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this schema objects create o k response has a 3xx status code
func (o *SchemaObjectsCreateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schema objects create o k response has a 4xx status code
func (o *SchemaObjectsCreateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this schema objects create o k response has a 5xx status code
func (o *SchemaObjectsCreateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this schema objects create o k response a status code equal to that given
func (o *SchemaObjectsCreateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the schema objects create o k response
func (o *SchemaObjectsCreateOK) Code() int {
	return 200
}

func (o *SchemaObjectsCreateOK) Error() string {
	return fmt.Sprintf("[POST /schema][%d] schemaObjectsCreateOK  %+v", 200, o.Payload)
}

func (o *SchemaObjectsCreateOK) String() string {
	return fmt.Sprintf("[POST /schema][%d] schemaObjectsCreateOK  %+v", 200, o.Payload)
}

func (o *SchemaObjectsCreateOK) GetPayload() *models.Class {
	return o.Payload
}

func (o *SchemaObjectsCreateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Class)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSchemaObjectsCreateUnauthorized creates a SchemaObjectsCreateUnauthorized with default headers values
func NewSchemaObjectsCreateUnauthorized() *SchemaObjectsCreateUnauthorized {
	return &SchemaObjectsCreateUnauthorized{}
}

/*
SchemaObjectsCreateUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type SchemaObjectsCreateUnauthorized struct {
}

// IsSuccess returns true when this schema objects create unauthorized response has a 2xx status code
func (o *SchemaObjectsCreateUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this schema objects create unauthorized response has a 3xx status code
func (o *SchemaObjectsCreateUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schema objects create unauthorized response has a 4xx status code
func (o *SchemaObjectsCreateUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this schema objects create unauthorized response has a 5xx status code
func (o *SchemaObjectsCreateUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this schema objects create unauthorized response a status code equal to that given
func (o *SchemaObjectsCreateUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the schema objects create unauthorized response
func (o *SchemaObjectsCreateUnauthorized) Code() int {
	return 401
}

func (o *SchemaObjectsCreateUnauthorized) Error() string {
	return fmt.Sprintf("[POST /schema][%d] schemaObjectsCreateUnauthorized ", 401)
}

func (o *SchemaObjectsCreateUnauthorized) String() string {
	return fmt.Sprintf("[POST /schema][%d] schemaObjectsCreateUnauthorized ", 401)
}

func (o *SchemaObjectsCreateUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSchemaObjectsCreateForbidden creates a SchemaObjectsCreateForbidden with default headers values
func NewSchemaObjectsCreateForbidden() *SchemaObjectsCreateForbidden {
	return &SchemaObjectsCreateForbidden{}
}

/*
SchemaObjectsCreateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type SchemaObjectsCreateForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this schema objects create forbidden response has a 2xx status code
func (o *SchemaObjectsCreateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this schema objects create forbidden response has a 3xx status code
func (o *SchemaObjectsCreateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schema objects create forbidden response has a 4xx status code
func (o *SchemaObjectsCreateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this schema objects create forbidden response has a 5xx status code
func (o *SchemaObjectsCreateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this schema objects create forbidden response a status code equal to that given
func (o *SchemaObjectsCreateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the schema objects create forbidden response
func (o *SchemaObjectsCreateForbidden) Code() int {
	return 403
}

func (o *SchemaObjectsCreateForbidden) Error() string {
	return fmt.Sprintf("[POST /schema][%d] schemaObjectsCreateForbidden  %+v", 403, o.Payload)
}

func (o *SchemaObjectsCreateForbidden) String() string {
	return fmt.Sprintf("[POST /schema][%d] schemaObjectsCreateForbidden  %+v", 403, o.Payload)
}

func (o *SchemaObjectsCreateForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SchemaObjectsCreateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSchemaObjectsCreateUnprocessableEntity creates a SchemaObjectsCreateUnprocessableEntity with default headers values
func NewSchemaObjectsCreateUnprocessableEntity() *SchemaObjectsCreateUnprocessableEntity {
	return &SchemaObjectsCreateUnprocessableEntity{}
}

/*
SchemaObjectsCreateUnprocessableEntity describes a response with status code 422, with default header values.

Invalid collection definition provided. Check the definition structure and properties.
*/
type SchemaObjectsCreateUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this schema objects create unprocessable entity response has a 2xx status code
func (o *SchemaObjectsCreateUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this schema objects create unprocessable entity response has a 3xx status code
func (o *SchemaObjectsCreateUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schema objects create unprocessable entity response has a 4xx status code
func (o *SchemaObjectsCreateUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this schema objects create unprocessable entity response has a 5xx status code
func (o *SchemaObjectsCreateUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this schema objects create unprocessable entity response a status code equal to that given
func (o *SchemaObjectsCreateUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the schema objects create unprocessable entity response
func (o *SchemaObjectsCreateUnprocessableEntity) Code() int {
	return 422
}

func (o *SchemaObjectsCreateUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /schema][%d] schemaObjectsCreateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *SchemaObjectsCreateUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /schema][%d] schemaObjectsCreateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *SchemaObjectsCreateUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SchemaObjectsCreateUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSchemaObjectsCreateInternalServerError creates a SchemaObjectsCreateInternalServerError with default headers values
func NewSchemaObjectsCreateInternalServerError() *SchemaObjectsCreateInternalServerError {
	return &SchemaObjectsCreateInternalServerError{}
}

/*
SchemaObjectsCreateInternalServerError describes a response with status code 500, with default header values.

An error occurred during collection creation. Check the ErrorResponse for details.
*/
type SchemaObjectsCreateInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this schema objects create internal server error response has a 2xx status code
func (o *SchemaObjectsCreateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this schema objects create internal server error response has a 3xx status code
func (o *SchemaObjectsCreateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schema objects create internal server error response has a 4xx status code
func (o *SchemaObjectsCreateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this schema objects create internal server error response has a 5xx status code
func (o *SchemaObjectsCreateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this schema objects create internal server error response a status code equal to that given
func (o *SchemaObjectsCreateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the schema objects create internal server error response
func (o *SchemaObjectsCreateInternalServerError) Code() int {
	return 500
}

func (o *SchemaObjectsCreateInternalServerError) Error() string {
	return fmt.Sprintf("[POST /schema][%d] schemaObjectsCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *SchemaObjectsCreateInternalServerError) String() string {
	return fmt.Sprintf("[POST /schema][%d] schemaObjectsCreateInternalServerError  %+v", 500, o.Payload)
}

func (o *SchemaObjectsCreateInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SchemaObjectsCreateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
