//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSchemaObjectsGetParams creates a new SchemaObjectsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSchemaObjectsGetParams() *SchemaObjectsGetParams {
	return &SchemaObjectsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSchemaObjectsGetParamsWithTimeout creates a new SchemaObjectsGetParams object
// with the ability to set a timeout on a request.
func NewSchemaObjectsGetParamsWithTimeout(timeout time.Duration) *SchemaObjectsGetParams {
	return &SchemaObjectsGetParams{
		timeout: timeout,
	}
}

// NewSchemaObjectsGetParamsWithContext creates a new SchemaObjectsGetParams object
// with the ability to set a context for a request.
func NewSchemaObjectsGetParamsWithContext(ctx context.Context) *SchemaObjectsGetParams {
	return &SchemaObjectsGetParams{
		Context: ctx,
	}
}

// NewSchemaObjectsGetParamsWithHTTPClient creates a new SchemaObjectsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSchemaObjectsGetParamsWithHTTPClient(client *http.Client) *SchemaObjectsGetParams {
	return &SchemaObjectsGetParams{
		HTTPClient: client,
	}
}

/*
SchemaObjectsGetParams contains all the parameters to send to the API endpoint

	for the schema objects get operation.

	Typically these are written to a http.Request.
*/
type SchemaObjectsGetParams struct {

	/* ClassName.

	   The name of the collection (class) to retrieve.
	*/
	ClassName string

	/* Consistency.

	   If true, the request is proxied to the cluster leader to ensure strong schema consistency. Default is true.

	   Default: true
	*/
	Consistency *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the schema objects get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SchemaObjectsGetParams) WithDefaults() *SchemaObjectsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the schema objects get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SchemaObjectsGetParams) SetDefaults() {
	var (
		consistencyDefault = bool(true)
	)

	val := SchemaObjectsGetParams{
		Consistency: &consistencyDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the schema objects get params
func (o *SchemaObjectsGetParams) WithTimeout(timeout time.Duration) *SchemaObjectsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the schema objects get params
func (o *SchemaObjectsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the schema objects get params
func (o *SchemaObjectsGetParams) WithContext(ctx context.Context) *SchemaObjectsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the schema objects get params
func (o *SchemaObjectsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the schema objects get params
func (o *SchemaObjectsGetParams) WithHTTPClient(client *http.Client) *SchemaObjectsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the schema objects get params
func (o *SchemaObjectsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClassName adds the className to the schema objects get params
func (o *SchemaObjectsGetParams) WithClassName(className string) *SchemaObjectsGetParams {
	o.SetClassName(className)
	return o
}

// SetClassName adds the className to the schema objects get params
func (o *SchemaObjectsGetParams) SetClassName(className string) {
	o.ClassName = className
}

// WithConsistency adds the consistency to the schema objects get params
func (o *SchemaObjectsGetParams) WithConsistency(consistency *bool) *SchemaObjectsGetParams {
	o.SetConsistency(consistency)
	return o
}

// SetConsistency adds the consistency to the schema objects get params
func (o *SchemaObjectsGetParams) SetConsistency(consistency *bool) {
	o.Consistency = consistency
}

// WriteToRequest writes these params to a swagger request
func (o *SchemaObjectsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param className
	if err := r.SetPathParam("className", o.ClassName); err != nil {
		return err
	}

	if o.Consistency != nil {

		// header param consistency
		if err := r.SetHeaderParam("consistency", swag.FormatBool(*o.Consistency)); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
