//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// SchemaObjectsShardsUpdateReader is a Reader for the SchemaObjectsShardsUpdate structure.
type SchemaObjectsShardsUpdateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SchemaObjectsShardsUpdateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSchemaObjectsShardsUpdateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewSchemaObjectsShardsUpdateUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSchemaObjectsShardsUpdateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewSchemaObjectsShardsUpdateNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewSchemaObjectsShardsUpdateUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSchemaObjectsShardsUpdateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSchemaObjectsShardsUpdateOK creates a SchemaObjectsShardsUpdateOK with default headers values
func NewSchemaObjectsShardsUpdateOK() *SchemaObjectsShardsUpdateOK {
	return &SchemaObjectsShardsUpdateOK{}
}

/*
SchemaObjectsShardsUpdateOK describes a response with status code 200, with default header values.

Shard status updated successfully.
*/
type SchemaObjectsShardsUpdateOK struct {
	Payload *models.ShardStatus
}

// IsSuccess returns true when this schema objects shards update o k response has a 2xx status code
func (o *SchemaObjectsShardsUpdateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this schema objects shards update o k response has a 3xx status code
func (o *SchemaObjectsShardsUpdateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schema objects shards update o k response has a 4xx status code
func (o *SchemaObjectsShardsUpdateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this schema objects shards update o k response has a 5xx status code
func (o *SchemaObjectsShardsUpdateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this schema objects shards update o k response a status code equal to that given
func (o *SchemaObjectsShardsUpdateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the schema objects shards update o k response
func (o *SchemaObjectsShardsUpdateOK) Code() int {
	return 200
}

func (o *SchemaObjectsShardsUpdateOK) Error() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateOK  %+v", 200, o.Payload)
}

func (o *SchemaObjectsShardsUpdateOK) String() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateOK  %+v", 200, o.Payload)
}

func (o *SchemaObjectsShardsUpdateOK) GetPayload() *models.ShardStatus {
	return o.Payload
}

func (o *SchemaObjectsShardsUpdateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ShardStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSchemaObjectsShardsUpdateUnauthorized creates a SchemaObjectsShardsUpdateUnauthorized with default headers values
func NewSchemaObjectsShardsUpdateUnauthorized() *SchemaObjectsShardsUpdateUnauthorized {
	return &SchemaObjectsShardsUpdateUnauthorized{}
}

/*
SchemaObjectsShardsUpdateUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type SchemaObjectsShardsUpdateUnauthorized struct {
}

// IsSuccess returns true when this schema objects shards update unauthorized response has a 2xx status code
func (o *SchemaObjectsShardsUpdateUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this schema objects shards update unauthorized response has a 3xx status code
func (o *SchemaObjectsShardsUpdateUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schema objects shards update unauthorized response has a 4xx status code
func (o *SchemaObjectsShardsUpdateUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this schema objects shards update unauthorized response has a 5xx status code
func (o *SchemaObjectsShardsUpdateUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this schema objects shards update unauthorized response a status code equal to that given
func (o *SchemaObjectsShardsUpdateUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the schema objects shards update unauthorized response
func (o *SchemaObjectsShardsUpdateUnauthorized) Code() int {
	return 401
}

func (o *SchemaObjectsShardsUpdateUnauthorized) Error() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateUnauthorized ", 401)
}

func (o *SchemaObjectsShardsUpdateUnauthorized) String() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateUnauthorized ", 401)
}

func (o *SchemaObjectsShardsUpdateUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSchemaObjectsShardsUpdateForbidden creates a SchemaObjectsShardsUpdateForbidden with default headers values
func NewSchemaObjectsShardsUpdateForbidden() *SchemaObjectsShardsUpdateForbidden {
	return &SchemaObjectsShardsUpdateForbidden{}
}

/*
SchemaObjectsShardsUpdateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type SchemaObjectsShardsUpdateForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this schema objects shards update forbidden response has a 2xx status code
func (o *SchemaObjectsShardsUpdateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this schema objects shards update forbidden response has a 3xx status code
func (o *SchemaObjectsShardsUpdateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schema objects shards update forbidden response has a 4xx status code
func (o *SchemaObjectsShardsUpdateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this schema objects shards update forbidden response has a 5xx status code
func (o *SchemaObjectsShardsUpdateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this schema objects shards update forbidden response a status code equal to that given
func (o *SchemaObjectsShardsUpdateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the schema objects shards update forbidden response
func (o *SchemaObjectsShardsUpdateForbidden) Code() int {
	return 403
}

func (o *SchemaObjectsShardsUpdateForbidden) Error() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateForbidden  %+v", 403, o.Payload)
}

func (o *SchemaObjectsShardsUpdateForbidden) String() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateForbidden  %+v", 403, o.Payload)
}

func (o *SchemaObjectsShardsUpdateForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SchemaObjectsShardsUpdateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSchemaObjectsShardsUpdateNotFound creates a SchemaObjectsShardsUpdateNotFound with default headers values
func NewSchemaObjectsShardsUpdateNotFound() *SchemaObjectsShardsUpdateNotFound {
	return &SchemaObjectsShardsUpdateNotFound{}
}

/*
SchemaObjectsShardsUpdateNotFound describes a response with status code 404, with default header values.

Collection or shard not found.
*/
type SchemaObjectsShardsUpdateNotFound struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this schema objects shards update not found response has a 2xx status code
func (o *SchemaObjectsShardsUpdateNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this schema objects shards update not found response has a 3xx status code
func (o *SchemaObjectsShardsUpdateNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schema objects shards update not found response has a 4xx status code
func (o *SchemaObjectsShardsUpdateNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this schema objects shards update not found response has a 5xx status code
func (o *SchemaObjectsShardsUpdateNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this schema objects shards update not found response a status code equal to that given
func (o *SchemaObjectsShardsUpdateNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the schema objects shards update not found response
func (o *SchemaObjectsShardsUpdateNotFound) Code() int {
	return 404
}

func (o *SchemaObjectsShardsUpdateNotFound) Error() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateNotFound  %+v", 404, o.Payload)
}

func (o *SchemaObjectsShardsUpdateNotFound) String() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateNotFound  %+v", 404, o.Payload)
}

func (o *SchemaObjectsShardsUpdateNotFound) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SchemaObjectsShardsUpdateNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSchemaObjectsShardsUpdateUnprocessableEntity creates a SchemaObjectsShardsUpdateUnprocessableEntity with default headers values
func NewSchemaObjectsShardsUpdateUnprocessableEntity() *SchemaObjectsShardsUpdateUnprocessableEntity {
	return &SchemaObjectsShardsUpdateUnprocessableEntity{}
}

/*
SchemaObjectsShardsUpdateUnprocessableEntity describes a response with status code 422, with default header values.

Invalid update attempt
*/
type SchemaObjectsShardsUpdateUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this schema objects shards update unprocessable entity response has a 2xx status code
func (o *SchemaObjectsShardsUpdateUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this schema objects shards update unprocessable entity response has a 3xx status code
func (o *SchemaObjectsShardsUpdateUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schema objects shards update unprocessable entity response has a 4xx status code
func (o *SchemaObjectsShardsUpdateUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this schema objects shards update unprocessable entity response has a 5xx status code
func (o *SchemaObjectsShardsUpdateUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this schema objects shards update unprocessable entity response a status code equal to that given
func (o *SchemaObjectsShardsUpdateUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the schema objects shards update unprocessable entity response
func (o *SchemaObjectsShardsUpdateUnprocessableEntity) Code() int {
	return 422
}

func (o *SchemaObjectsShardsUpdateUnprocessableEntity) Error() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *SchemaObjectsShardsUpdateUnprocessableEntity) String() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *SchemaObjectsShardsUpdateUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SchemaObjectsShardsUpdateUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSchemaObjectsShardsUpdateInternalServerError creates a SchemaObjectsShardsUpdateInternalServerError with default headers values
func NewSchemaObjectsShardsUpdateInternalServerError() *SchemaObjectsShardsUpdateInternalServerError {
	return &SchemaObjectsShardsUpdateInternalServerError{}
}

/*
SchemaObjectsShardsUpdateInternalServerError describes a response with status code 500, with default header values.

An error occurred while updating the shard status. Check the ErrorResponse for details.
*/
type SchemaObjectsShardsUpdateInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this schema objects shards update internal server error response has a 2xx status code
func (o *SchemaObjectsShardsUpdateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this schema objects shards update internal server error response has a 3xx status code
func (o *SchemaObjectsShardsUpdateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this schema objects shards update internal server error response has a 4xx status code
func (o *SchemaObjectsShardsUpdateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this schema objects shards update internal server error response has a 5xx status code
func (o *SchemaObjectsShardsUpdateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this schema objects shards update internal server error response a status code equal to that given
func (o *SchemaObjectsShardsUpdateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the schema objects shards update internal server error response
func (o *SchemaObjectsShardsUpdateInternalServerError) Code() int {
	return 500
}

func (o *SchemaObjectsShardsUpdateInternalServerError) Error() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateInternalServerError  %+v", 500, o.Payload)
}

func (o *SchemaObjectsShardsUpdateInternalServerError) String() string {
	return fmt.Sprintf("[PUT /schema/{className}/shards/{shardName}][%d] schemaObjectsShardsUpdateInternalServerError  %+v", 500, o.Payload)
}

func (o *SchemaObjectsShardsUpdateInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SchemaObjectsShardsUpdateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
