//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// TenantExistsReader is a Reader for the TenantExists structure.
type TenantExistsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TenantExistsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTenantExistsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewTenantExistsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewTenantExistsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewTenantExistsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewTenantExistsUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewTenantExistsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewTenantExistsOK creates a TenantExistsOK with default headers values
func NewTenantExistsOK() *TenantExistsOK {
	return &TenantExistsOK{}
}

/*
TenantExistsOK describes a response with status code 200, with default header values.

The tenant exists in the specified collection.
*/
type TenantExistsOK struct {
}

// IsSuccess returns true when this tenant exists o k response has a 2xx status code
func (o *TenantExistsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this tenant exists o k response has a 3xx status code
func (o *TenantExistsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenant exists o k response has a 4xx status code
func (o *TenantExistsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this tenant exists o k response has a 5xx status code
func (o *TenantExistsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this tenant exists o k response a status code equal to that given
func (o *TenantExistsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the tenant exists o k response
func (o *TenantExistsOK) Code() int {
	return 200
}

func (o *TenantExistsOK) Error() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsOK ", 200)
}

func (o *TenantExistsOK) String() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsOK ", 200)
}

func (o *TenantExistsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTenantExistsUnauthorized creates a TenantExistsUnauthorized with default headers values
func NewTenantExistsUnauthorized() *TenantExistsUnauthorized {
	return &TenantExistsUnauthorized{}
}

/*
TenantExistsUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type TenantExistsUnauthorized struct {
}

// IsSuccess returns true when this tenant exists unauthorized response has a 2xx status code
func (o *TenantExistsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenant exists unauthorized response has a 3xx status code
func (o *TenantExistsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenant exists unauthorized response has a 4xx status code
func (o *TenantExistsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenant exists unauthorized response has a 5xx status code
func (o *TenantExistsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this tenant exists unauthorized response a status code equal to that given
func (o *TenantExistsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the tenant exists unauthorized response
func (o *TenantExistsUnauthorized) Code() int {
	return 401
}

func (o *TenantExistsUnauthorized) Error() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsUnauthorized ", 401)
}

func (o *TenantExistsUnauthorized) String() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsUnauthorized ", 401)
}

func (o *TenantExistsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTenantExistsForbidden creates a TenantExistsForbidden with default headers values
func NewTenantExistsForbidden() *TenantExistsForbidden {
	return &TenantExistsForbidden{}
}

/*
TenantExistsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type TenantExistsForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenant exists forbidden response has a 2xx status code
func (o *TenantExistsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenant exists forbidden response has a 3xx status code
func (o *TenantExistsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenant exists forbidden response has a 4xx status code
func (o *TenantExistsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenant exists forbidden response has a 5xx status code
func (o *TenantExistsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this tenant exists forbidden response a status code equal to that given
func (o *TenantExistsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the tenant exists forbidden response
func (o *TenantExistsForbidden) Code() int {
	return 403
}

func (o *TenantExistsForbidden) Error() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsForbidden  %+v", 403, o.Payload)
}

func (o *TenantExistsForbidden) String() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsForbidden  %+v", 403, o.Payload)
}

func (o *TenantExistsForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantExistsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTenantExistsNotFound creates a TenantExistsNotFound with default headers values
func NewTenantExistsNotFound() *TenantExistsNotFound {
	return &TenantExistsNotFound{}
}

/*
TenantExistsNotFound describes a response with status code 404, with default header values.

Tenant or collection not found.
*/
type TenantExistsNotFound struct {
}

// IsSuccess returns true when this tenant exists not found response has a 2xx status code
func (o *TenantExistsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenant exists not found response has a 3xx status code
func (o *TenantExistsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenant exists not found response has a 4xx status code
func (o *TenantExistsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenant exists not found response has a 5xx status code
func (o *TenantExistsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this tenant exists not found response a status code equal to that given
func (o *TenantExistsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the tenant exists not found response
func (o *TenantExistsNotFound) Code() int {
	return 404
}

func (o *TenantExistsNotFound) Error() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsNotFound ", 404)
}

func (o *TenantExistsNotFound) String() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsNotFound ", 404)
}

func (o *TenantExistsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTenantExistsUnprocessableEntity creates a TenantExistsUnprocessableEntity with default headers values
func NewTenantExistsUnprocessableEntity() *TenantExistsUnprocessableEntity {
	return &TenantExistsUnprocessableEntity{}
}

/*
TenantExistsUnprocessableEntity describes a response with status code 422, with default header values.

Invalid request.
*/
type TenantExistsUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenant exists unprocessable entity response has a 2xx status code
func (o *TenantExistsUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenant exists unprocessable entity response has a 3xx status code
func (o *TenantExistsUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenant exists unprocessable entity response has a 4xx status code
func (o *TenantExistsUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenant exists unprocessable entity response has a 5xx status code
func (o *TenantExistsUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this tenant exists unprocessable entity response a status code equal to that given
func (o *TenantExistsUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the tenant exists unprocessable entity response
func (o *TenantExistsUnprocessableEntity) Code() int {
	return 422
}

func (o *TenantExistsUnprocessableEntity) Error() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *TenantExistsUnprocessableEntity) String() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *TenantExistsUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantExistsUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTenantExistsInternalServerError creates a TenantExistsInternalServerError with default headers values
func NewTenantExistsInternalServerError() *TenantExistsInternalServerError {
	return &TenantExistsInternalServerError{}
}

/*
TenantExistsInternalServerError describes a response with status code 500, with default header values.

An error occurred during the check. Check the ErrorResponse for details.
*/
type TenantExistsInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenant exists internal server error response has a 2xx status code
func (o *TenantExistsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenant exists internal server error response has a 3xx status code
func (o *TenantExistsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenant exists internal server error response has a 4xx status code
func (o *TenantExistsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this tenant exists internal server error response has a 5xx status code
func (o *TenantExistsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this tenant exists internal server error response a status code equal to that given
func (o *TenantExistsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the tenant exists internal server error response
func (o *TenantExistsInternalServerError) Code() int {
	return 500
}

func (o *TenantExistsInternalServerError) Error() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsInternalServerError  %+v", 500, o.Payload)
}

func (o *TenantExistsInternalServerError) String() string {
	return fmt.Sprintf("[HEAD /schema/{className}/tenants/{tenantName}][%d] tenantExistsInternalServerError  %+v", 500, o.Payload)
}

func (o *TenantExistsInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantExistsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
