//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package schema

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// TenantsUpdateReader is a Reader for the TenantsUpdate structure.
type TenantsUpdateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *TenantsUpdateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewTenantsUpdateOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewTenantsUpdateUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewTenantsUpdateForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewTenantsUpdateUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewTenantsUpdateInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewTenantsUpdateOK creates a TenantsUpdateOK with default headers values
func NewTenantsUpdateOK() *TenantsUpdateOK {
	return &TenantsUpdateOK{}
}

/*
TenantsUpdateOK describes a response with status code 200, with default header values.

Tenant statuses updated successfully.
*/
type TenantsUpdateOK struct {
	Payload []*models.Tenant
}

// IsSuccess returns true when this tenants update o k response has a 2xx status code
func (o *TenantsUpdateOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this tenants update o k response has a 3xx status code
func (o *TenantsUpdateOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants update o k response has a 4xx status code
func (o *TenantsUpdateOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this tenants update o k response has a 5xx status code
func (o *TenantsUpdateOK) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants update o k response a status code equal to that given
func (o *TenantsUpdateOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the tenants update o k response
func (o *TenantsUpdateOK) Code() int {
	return 200
}

func (o *TenantsUpdateOK) Error() string {
	return fmt.Sprintf("[PUT /schema/{className}/tenants][%d] tenantsUpdateOK  %+v", 200, o.Payload)
}

func (o *TenantsUpdateOK) String() string {
	return fmt.Sprintf("[PUT /schema/{className}/tenants][%d] tenantsUpdateOK  %+v", 200, o.Payload)
}

func (o *TenantsUpdateOK) GetPayload() []*models.Tenant {
	return o.Payload
}

func (o *TenantsUpdateOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTenantsUpdateUnauthorized creates a TenantsUpdateUnauthorized with default headers values
func NewTenantsUpdateUnauthorized() *TenantsUpdateUnauthorized {
	return &TenantsUpdateUnauthorized{}
}

/*
TenantsUpdateUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type TenantsUpdateUnauthorized struct {
}

// IsSuccess returns true when this tenants update unauthorized response has a 2xx status code
func (o *TenantsUpdateUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants update unauthorized response has a 3xx status code
func (o *TenantsUpdateUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants update unauthorized response has a 4xx status code
func (o *TenantsUpdateUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenants update unauthorized response has a 5xx status code
func (o *TenantsUpdateUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants update unauthorized response a status code equal to that given
func (o *TenantsUpdateUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the tenants update unauthorized response
func (o *TenantsUpdateUnauthorized) Code() int {
	return 401
}

func (o *TenantsUpdateUnauthorized) Error() string {
	return fmt.Sprintf("[PUT /schema/{className}/tenants][%d] tenantsUpdateUnauthorized ", 401)
}

func (o *TenantsUpdateUnauthorized) String() string {
	return fmt.Sprintf("[PUT /schema/{className}/tenants][%d] tenantsUpdateUnauthorized ", 401)
}

func (o *TenantsUpdateUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewTenantsUpdateForbidden creates a TenantsUpdateForbidden with default headers values
func NewTenantsUpdateForbidden() *TenantsUpdateForbidden {
	return &TenantsUpdateForbidden{}
}

/*
TenantsUpdateForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type TenantsUpdateForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenants update forbidden response has a 2xx status code
func (o *TenantsUpdateForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants update forbidden response has a 3xx status code
func (o *TenantsUpdateForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants update forbidden response has a 4xx status code
func (o *TenantsUpdateForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenants update forbidden response has a 5xx status code
func (o *TenantsUpdateForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants update forbidden response a status code equal to that given
func (o *TenantsUpdateForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the tenants update forbidden response
func (o *TenantsUpdateForbidden) Code() int {
	return 403
}

func (o *TenantsUpdateForbidden) Error() string {
	return fmt.Sprintf("[PUT /schema/{className}/tenants][%d] tenantsUpdateForbidden  %+v", 403, o.Payload)
}

func (o *TenantsUpdateForbidden) String() string {
	return fmt.Sprintf("[PUT /schema/{className}/tenants][%d] tenantsUpdateForbidden  %+v", 403, o.Payload)
}

func (o *TenantsUpdateForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantsUpdateForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTenantsUpdateUnprocessableEntity creates a TenantsUpdateUnprocessableEntity with default headers values
func NewTenantsUpdateUnprocessableEntity() *TenantsUpdateUnprocessableEntity {
	return &TenantsUpdateUnprocessableEntity{}
}

/*
TenantsUpdateUnprocessableEntity describes a response with status code 422, with default header values.

Invalid update request.
*/
type TenantsUpdateUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenants update unprocessable entity response has a 2xx status code
func (o *TenantsUpdateUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants update unprocessable entity response has a 3xx status code
func (o *TenantsUpdateUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants update unprocessable entity response has a 4xx status code
func (o *TenantsUpdateUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this tenants update unprocessable entity response has a 5xx status code
func (o *TenantsUpdateUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this tenants update unprocessable entity response a status code equal to that given
func (o *TenantsUpdateUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the tenants update unprocessable entity response
func (o *TenantsUpdateUnprocessableEntity) Code() int {
	return 422
}

func (o *TenantsUpdateUnprocessableEntity) Error() string {
	return fmt.Sprintf("[PUT /schema/{className}/tenants][%d] tenantsUpdateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *TenantsUpdateUnprocessableEntity) String() string {
	return fmt.Sprintf("[PUT /schema/{className}/tenants][%d] tenantsUpdateUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *TenantsUpdateUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantsUpdateUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewTenantsUpdateInternalServerError creates a TenantsUpdateInternalServerError with default headers values
func NewTenantsUpdateInternalServerError() *TenantsUpdateInternalServerError {
	return &TenantsUpdateInternalServerError{}
}

/*
TenantsUpdateInternalServerError describes a response with status code 500, with default header values.

An error occurred while updating tenants. Check the ErrorResponse for details.
*/
type TenantsUpdateInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this tenants update internal server error response has a 2xx status code
func (o *TenantsUpdateInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this tenants update internal server error response has a 3xx status code
func (o *TenantsUpdateInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this tenants update internal server error response has a 4xx status code
func (o *TenantsUpdateInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this tenants update internal server error response has a 5xx status code
func (o *TenantsUpdateInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this tenants update internal server error response a status code equal to that given
func (o *TenantsUpdateInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the tenants update internal server error response
func (o *TenantsUpdateInternalServerError) Code() int {
	return 500
}

func (o *TenantsUpdateInternalServerError) Error() string {
	return fmt.Sprintf("[PUT /schema/{className}/tenants][%d] tenantsUpdateInternalServerError  %+v", 500, o.Payload)
}

func (o *TenantsUpdateInternalServerError) String() string {
	return fmt.Sprintf("[PUT /schema/{className}/tenants][%d] tenantsUpdateInternalServerError  %+v", 500, o.Payload)
}

func (o *TenantsUpdateInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *TenantsUpdateInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
