//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/weaviate/weaviate/entities/models"
)

// DeactivateUserReader is a Reader for the DeactivateUser structure.
type DeactivateUserReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeactivateUserReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeactivateUserOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeactivateUserBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDeactivateUserUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeactivateUserForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeactivateUserNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewDeactivateUserConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 422:
		result := NewDeactivateUserUnprocessableEntity()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeactivateUserInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDeactivateUserOK creates a DeactivateUserOK with default headers values
func NewDeactivateUserOK() *DeactivateUserOK {
	return &DeactivateUserOK{}
}

/*
DeactivateUserOK describes a response with status code 200, with default header values.

User successfully deactivated.
*/
type DeactivateUserOK struct {
}

// IsSuccess returns true when this deactivate user o k response has a 2xx status code
func (o *DeactivateUserOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this deactivate user o k response has a 3xx status code
func (o *DeactivateUserOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this deactivate user o k response has a 4xx status code
func (o *DeactivateUserOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this deactivate user o k response has a 5xx status code
func (o *DeactivateUserOK) IsServerError() bool {
	return false
}

// IsCode returns true when this deactivate user o k response a status code equal to that given
func (o *DeactivateUserOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the deactivate user o k response
func (o *DeactivateUserOK) Code() int {
	return 200
}

func (o *DeactivateUserOK) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserOK ", 200)
}

func (o *DeactivateUserOK) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserOK ", 200)
}

func (o *DeactivateUserOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeactivateUserBadRequest creates a DeactivateUserBadRequest with default headers values
func NewDeactivateUserBadRequest() *DeactivateUserBadRequest {
	return &DeactivateUserBadRequest{}
}

/*
DeactivateUserBadRequest describes a response with status code 400, with default header values.

Malformed request.
*/
type DeactivateUserBadRequest struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this deactivate user bad request response has a 2xx status code
func (o *DeactivateUserBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this deactivate user bad request response has a 3xx status code
func (o *DeactivateUserBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this deactivate user bad request response has a 4xx status code
func (o *DeactivateUserBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this deactivate user bad request response has a 5xx status code
func (o *DeactivateUserBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this deactivate user bad request response a status code equal to that given
func (o *DeactivateUserBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the deactivate user bad request response
func (o *DeactivateUserBadRequest) Code() int {
	return 400
}

func (o *DeactivateUserBadRequest) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserBadRequest  %+v", 400, o.Payload)
}

func (o *DeactivateUserBadRequest) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserBadRequest  %+v", 400, o.Payload)
}

func (o *DeactivateUserBadRequest) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeactivateUserBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeactivateUserUnauthorized creates a DeactivateUserUnauthorized with default headers values
func NewDeactivateUserUnauthorized() *DeactivateUserUnauthorized {
	return &DeactivateUserUnauthorized{}
}

/*
DeactivateUserUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type DeactivateUserUnauthorized struct {
}

// IsSuccess returns true when this deactivate user unauthorized response has a 2xx status code
func (o *DeactivateUserUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this deactivate user unauthorized response has a 3xx status code
func (o *DeactivateUserUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this deactivate user unauthorized response has a 4xx status code
func (o *DeactivateUserUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this deactivate user unauthorized response has a 5xx status code
func (o *DeactivateUserUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this deactivate user unauthorized response a status code equal to that given
func (o *DeactivateUserUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the deactivate user unauthorized response
func (o *DeactivateUserUnauthorized) Code() int {
	return 401
}

func (o *DeactivateUserUnauthorized) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserUnauthorized ", 401)
}

func (o *DeactivateUserUnauthorized) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserUnauthorized ", 401)
}

func (o *DeactivateUserUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeactivateUserForbidden creates a DeactivateUserForbidden with default headers values
func NewDeactivateUserForbidden() *DeactivateUserForbidden {
	return &DeactivateUserForbidden{}
}

/*
DeactivateUserForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeactivateUserForbidden struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this deactivate user forbidden response has a 2xx status code
func (o *DeactivateUserForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this deactivate user forbidden response has a 3xx status code
func (o *DeactivateUserForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this deactivate user forbidden response has a 4xx status code
func (o *DeactivateUserForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this deactivate user forbidden response has a 5xx status code
func (o *DeactivateUserForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this deactivate user forbidden response a status code equal to that given
func (o *DeactivateUserForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the deactivate user forbidden response
func (o *DeactivateUserForbidden) Code() int {
	return 403
}

func (o *DeactivateUserForbidden) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserForbidden  %+v", 403, o.Payload)
}

func (o *DeactivateUserForbidden) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserForbidden  %+v", 403, o.Payload)
}

func (o *DeactivateUserForbidden) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeactivateUserForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeactivateUserNotFound creates a DeactivateUserNotFound with default headers values
func NewDeactivateUserNotFound() *DeactivateUserNotFound {
	return &DeactivateUserNotFound{}
}

/*
DeactivateUserNotFound describes a response with status code 404, with default header values.

User not found.
*/
type DeactivateUserNotFound struct {
}

// IsSuccess returns true when this deactivate user not found response has a 2xx status code
func (o *DeactivateUserNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this deactivate user not found response has a 3xx status code
func (o *DeactivateUserNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this deactivate user not found response has a 4xx status code
func (o *DeactivateUserNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this deactivate user not found response has a 5xx status code
func (o *DeactivateUserNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this deactivate user not found response a status code equal to that given
func (o *DeactivateUserNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the deactivate user not found response
func (o *DeactivateUserNotFound) Code() int {
	return 404
}

func (o *DeactivateUserNotFound) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserNotFound ", 404)
}

func (o *DeactivateUserNotFound) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserNotFound ", 404)
}

func (o *DeactivateUserNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeactivateUserConflict creates a DeactivateUserConflict with default headers values
func NewDeactivateUserConflict() *DeactivateUserConflict {
	return &DeactivateUserConflict{}
}

/*
DeactivateUserConflict describes a response with status code 409, with default header values.

User already deactivated.
*/
type DeactivateUserConflict struct {
}

// IsSuccess returns true when this deactivate user conflict response has a 2xx status code
func (o *DeactivateUserConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this deactivate user conflict response has a 3xx status code
func (o *DeactivateUserConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this deactivate user conflict response has a 4xx status code
func (o *DeactivateUserConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this deactivate user conflict response has a 5xx status code
func (o *DeactivateUserConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this deactivate user conflict response a status code equal to that given
func (o *DeactivateUserConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the deactivate user conflict response
func (o *DeactivateUserConflict) Code() int {
	return 409
}

func (o *DeactivateUserConflict) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserConflict ", 409)
}

func (o *DeactivateUserConflict) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserConflict ", 409)
}

func (o *DeactivateUserConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeactivateUserUnprocessableEntity creates a DeactivateUserUnprocessableEntity with default headers values
func NewDeactivateUserUnprocessableEntity() *DeactivateUserUnprocessableEntity {
	return &DeactivateUserUnprocessableEntity{}
}

/*
DeactivateUserUnprocessableEntity describes a response with status code 422, with default header values.

The request syntax is correct, but the server couldn't process it due to semantic issues. Please check the values in your request.
*/
type DeactivateUserUnprocessableEntity struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this deactivate user unprocessable entity response has a 2xx status code
func (o *DeactivateUserUnprocessableEntity) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this deactivate user unprocessable entity response has a 3xx status code
func (o *DeactivateUserUnprocessableEntity) IsRedirect() bool {
	return false
}

// IsClientError returns true when this deactivate user unprocessable entity response has a 4xx status code
func (o *DeactivateUserUnprocessableEntity) IsClientError() bool {
	return true
}

// IsServerError returns true when this deactivate user unprocessable entity response has a 5xx status code
func (o *DeactivateUserUnprocessableEntity) IsServerError() bool {
	return false
}

// IsCode returns true when this deactivate user unprocessable entity response a status code equal to that given
func (o *DeactivateUserUnprocessableEntity) IsCode(code int) bool {
	return code == 422
}

// Code gets the status code for the deactivate user unprocessable entity response
func (o *DeactivateUserUnprocessableEntity) Code() int {
	return 422
}

func (o *DeactivateUserUnprocessableEntity) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *DeactivateUserUnprocessableEntity) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserUnprocessableEntity  %+v", 422, o.Payload)
}

func (o *DeactivateUserUnprocessableEntity) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeactivateUserUnprocessableEntity) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeactivateUserInternalServerError creates a DeactivateUserInternalServerError with default headers values
func NewDeactivateUserInternalServerError() *DeactivateUserInternalServerError {
	return &DeactivateUserInternalServerError{}
}

/*
DeactivateUserInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type DeactivateUserInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this deactivate user internal server error response has a 2xx status code
func (o *DeactivateUserInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this deactivate user internal server error response has a 3xx status code
func (o *DeactivateUserInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this deactivate user internal server error response has a 4xx status code
func (o *DeactivateUserInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this deactivate user internal server error response has a 5xx status code
func (o *DeactivateUserInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this deactivate user internal server error response a status code equal to that given
func (o *DeactivateUserInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the deactivate user internal server error response
func (o *DeactivateUserInternalServerError) Code() int {
	return 500
}

func (o *DeactivateUserInternalServerError) Error() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserInternalServerError  %+v", 500, o.Payload)
}

func (o *DeactivateUserInternalServerError) String() string {
	return fmt.Sprintf("[POST /users/db/{user_id}/deactivate][%d] deactivateUserInternalServerError  %+v", 500, o.Payload)
}

func (o *DeactivateUserInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DeactivateUserInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
DeactivateUserBody deactivate user body
swagger:model DeactivateUserBody
*/
type DeactivateUserBody struct {

	// Whether the API key should be revoked when deactivating the user.
	RevokeKey *bool `json:"revoke_key,omitempty"`
}

// Validate validates this deactivate user body
func (o *DeactivateUserBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this deactivate user body based on context it is used
func (o *DeactivateUserBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *DeactivateUserBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *DeactivateUserBody) UnmarshalBinary(b []byte) error {
	var res DeactivateUserBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
