//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/weaviate/weaviate/entities/models"
)

// GetOwnInfoReader is a Reader for the GetOwnInfo structure.
type GetOwnInfoReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetOwnInfoReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetOwnInfoOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetOwnInfoUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetOwnInfoInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewGetOwnInfoNotImplemented()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetOwnInfoOK creates a GetOwnInfoOK with default headers values
func NewGetOwnInfoOK() *GetOwnInfoOK {
	return &GetOwnInfoOK{}
}

/*
GetOwnInfoOK describes a response with status code 200, with default header values.

Info about the user.
*/
type GetOwnInfoOK struct {
	Payload *models.UserOwnInfo
}

// IsSuccess returns true when this get own info o k response has a 2xx status code
func (o *GetOwnInfoOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get own info o k response has a 3xx status code
func (o *GetOwnInfoOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get own info o k response has a 4xx status code
func (o *GetOwnInfoOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get own info o k response has a 5xx status code
func (o *GetOwnInfoOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get own info o k response a status code equal to that given
func (o *GetOwnInfoOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get own info o k response
func (o *GetOwnInfoOK) Code() int {
	return 200
}

func (o *GetOwnInfoOK) Error() string {
	return fmt.Sprintf("[GET /users/own-info][%d] getOwnInfoOK  %+v", 200, o.Payload)
}

func (o *GetOwnInfoOK) String() string {
	return fmt.Sprintf("[GET /users/own-info][%d] getOwnInfoOK  %+v", 200, o.Payload)
}

func (o *GetOwnInfoOK) GetPayload() *models.UserOwnInfo {
	return o.Payload
}

func (o *GetOwnInfoOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.UserOwnInfo)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetOwnInfoUnauthorized creates a GetOwnInfoUnauthorized with default headers values
func NewGetOwnInfoUnauthorized() *GetOwnInfoUnauthorized {
	return &GetOwnInfoUnauthorized{}
}

/*
GetOwnInfoUnauthorized describes a response with status code 401, with default header values.

Unauthorized or invalid credentials.
*/
type GetOwnInfoUnauthorized struct {
}

// IsSuccess returns true when this get own info unauthorized response has a 2xx status code
func (o *GetOwnInfoUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get own info unauthorized response has a 3xx status code
func (o *GetOwnInfoUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get own info unauthorized response has a 4xx status code
func (o *GetOwnInfoUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get own info unauthorized response has a 5xx status code
func (o *GetOwnInfoUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get own info unauthorized response a status code equal to that given
func (o *GetOwnInfoUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get own info unauthorized response
func (o *GetOwnInfoUnauthorized) Code() int {
	return 401
}

func (o *GetOwnInfoUnauthorized) Error() string {
	return fmt.Sprintf("[GET /users/own-info][%d] getOwnInfoUnauthorized ", 401)
}

func (o *GetOwnInfoUnauthorized) String() string {
	return fmt.Sprintf("[GET /users/own-info][%d] getOwnInfoUnauthorized ", 401)
}

func (o *GetOwnInfoUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetOwnInfoInternalServerError creates a GetOwnInfoInternalServerError with default headers values
func NewGetOwnInfoInternalServerError() *GetOwnInfoInternalServerError {
	return &GetOwnInfoInternalServerError{}
}

/*
GetOwnInfoInternalServerError describes a response with status code 500, with default header values.

An error has occurred while trying to fulfill the request. Most likely the ErrorResponse will contain more information about the error.
*/
type GetOwnInfoInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get own info internal server error response has a 2xx status code
func (o *GetOwnInfoInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get own info internal server error response has a 3xx status code
func (o *GetOwnInfoInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get own info internal server error response has a 4xx status code
func (o *GetOwnInfoInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get own info internal server error response has a 5xx status code
func (o *GetOwnInfoInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get own info internal server error response a status code equal to that given
func (o *GetOwnInfoInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get own info internal server error response
func (o *GetOwnInfoInternalServerError) Code() int {
	return 500
}

func (o *GetOwnInfoInternalServerError) Error() string {
	return fmt.Sprintf("[GET /users/own-info][%d] getOwnInfoInternalServerError  %+v", 500, o.Payload)
}

func (o *GetOwnInfoInternalServerError) String() string {
	return fmt.Sprintf("[GET /users/own-info][%d] getOwnInfoInternalServerError  %+v", 500, o.Payload)
}

func (o *GetOwnInfoInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetOwnInfoInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetOwnInfoNotImplemented creates a GetOwnInfoNotImplemented with default headers values
func NewGetOwnInfoNotImplemented() *GetOwnInfoNotImplemented {
	return &GetOwnInfoNotImplemented{}
}

/*
GetOwnInfoNotImplemented describes a response with status code 501, with default header values.

Replica movement operations are disabled.
*/
type GetOwnInfoNotImplemented struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get own info not implemented response has a 2xx status code
func (o *GetOwnInfoNotImplemented) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get own info not implemented response has a 3xx status code
func (o *GetOwnInfoNotImplemented) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get own info not implemented response has a 4xx status code
func (o *GetOwnInfoNotImplemented) IsClientError() bool {
	return false
}

// IsServerError returns true when this get own info not implemented response has a 5xx status code
func (o *GetOwnInfoNotImplemented) IsServerError() bool {
	return true
}

// IsCode returns true when this get own info not implemented response a status code equal to that given
func (o *GetOwnInfoNotImplemented) IsCode(code int) bool {
	return code == 501
}

// Code gets the status code for the get own info not implemented response
func (o *GetOwnInfoNotImplemented) Code() int {
	return 501
}

func (o *GetOwnInfoNotImplemented) Error() string {
	return fmt.Sprintf("[GET /users/own-info][%d] getOwnInfoNotImplemented  %+v", 501, o.Payload)
}

func (o *GetOwnInfoNotImplemented) String() string {
	return fmt.Sprintf("[GET /users/own-info][%d] getOwnInfoNotImplemented  %+v", 501, o.Payload)
}

func (o *GetOwnInfoNotImplemented) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetOwnInfoNotImplemented) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
