//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetUserInfoParams creates a new GetUserInfoParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetUserInfoParams() *GetUserInfoParams {
	return &GetUserInfoParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetUserInfoParamsWithTimeout creates a new GetUserInfoParams object
// with the ability to set a timeout on a request.
func NewGetUserInfoParamsWithTimeout(timeout time.Duration) *GetUserInfoParams {
	return &GetUserInfoParams{
		timeout: timeout,
	}
}

// NewGetUserInfoParamsWithContext creates a new GetUserInfoParams object
// with the ability to set a context for a request.
func NewGetUserInfoParamsWithContext(ctx context.Context) *GetUserInfoParams {
	return &GetUserInfoParams{
		Context: ctx,
	}
}

// NewGetUserInfoParamsWithHTTPClient creates a new GetUserInfoParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetUserInfoParamsWithHTTPClient(client *http.Client) *GetUserInfoParams {
	return &GetUserInfoParams{
		HTTPClient: client,
	}
}

/*
GetUserInfoParams contains all the parameters to send to the API endpoint

	for the get user info operation.

	Typically these are written to a http.Request.
*/
type GetUserInfoParams struct {

	/* IncludeLastUsedTime.

	   Whether to include the last used time of the given user
	*/
	IncludeLastUsedTime *bool

	/* UserID.

	   The name of the user.
	*/
	UserID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get user info params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetUserInfoParams) WithDefaults() *GetUserInfoParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get user info params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetUserInfoParams) SetDefaults() {
	var (
		includeLastUsedTimeDefault = bool(false)
	)

	val := GetUserInfoParams{
		IncludeLastUsedTime: &includeLastUsedTimeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get user info params
func (o *GetUserInfoParams) WithTimeout(timeout time.Duration) *GetUserInfoParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get user info params
func (o *GetUserInfoParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get user info params
func (o *GetUserInfoParams) WithContext(ctx context.Context) *GetUserInfoParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get user info params
func (o *GetUserInfoParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get user info params
func (o *GetUserInfoParams) WithHTTPClient(client *http.Client) *GetUserInfoParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get user info params
func (o *GetUserInfoParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIncludeLastUsedTime adds the includeLastUsedTime to the get user info params
func (o *GetUserInfoParams) WithIncludeLastUsedTime(includeLastUsedTime *bool) *GetUserInfoParams {
	o.SetIncludeLastUsedTime(includeLastUsedTime)
	return o
}

// SetIncludeLastUsedTime adds the includeLastUsedTime to the get user info params
func (o *GetUserInfoParams) SetIncludeLastUsedTime(includeLastUsedTime *bool) {
	o.IncludeLastUsedTime = includeLastUsedTime
}

// WithUserID adds the userID to the get user info params
func (o *GetUserInfoParams) WithUserID(userID string) *GetUserInfoParams {
	o.SetUserID(userID)
	return o
}

// SetUserID adds the userId to the get user info params
func (o *GetUserInfoParams) SetUserID(userID string) {
	o.UserID = userID
}

// WriteToRequest writes these params to a swagger request
func (o *GetUserInfoParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.IncludeLastUsedTime != nil {

		// query param includeLastUsedTime
		var qrIncludeLastUsedTime bool

		if o.IncludeLastUsedTime != nil {
			qrIncludeLastUsedTime = *o.IncludeLastUsedTime
		}
		qIncludeLastUsedTime := swag.FormatBool(qrIncludeLastUsedTime)
		if qIncludeLastUsedTime != "" {

			if err := r.SetQueryParam("includeLastUsedTime", qIncludeLastUsedTime); err != nil {
				return err
			}
		}
	}

	// path param user_id
	if err := r.SetPathParam("user_id", o.UserID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
