//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListAllUsersParams creates a new ListAllUsersParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListAllUsersParams() *ListAllUsersParams {
	return &ListAllUsersParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListAllUsersParamsWithTimeout creates a new ListAllUsersParams object
// with the ability to set a timeout on a request.
func NewListAllUsersParamsWithTimeout(timeout time.Duration) *ListAllUsersParams {
	return &ListAllUsersParams{
		timeout: timeout,
	}
}

// NewListAllUsersParamsWithContext creates a new ListAllUsersParams object
// with the ability to set a context for a request.
func NewListAllUsersParamsWithContext(ctx context.Context) *ListAllUsersParams {
	return &ListAllUsersParams{
		Context: ctx,
	}
}

// NewListAllUsersParamsWithHTTPClient creates a new ListAllUsersParams object
// with the ability to set a custom HTTPClient for a request.
func NewListAllUsersParamsWithHTTPClient(client *http.Client) *ListAllUsersParams {
	return &ListAllUsersParams{
		HTTPClient: client,
	}
}

/*
ListAllUsersParams contains all the parameters to send to the API endpoint

	for the list all users operation.

	Typically these are written to a http.Request.
*/
type ListAllUsersParams struct {

	/* IncludeLastUsedTime.

	   Whether to include the last time the users were utilized.
	*/
	IncludeLastUsedTime *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list all users params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListAllUsersParams) WithDefaults() *ListAllUsersParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list all users params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListAllUsersParams) SetDefaults() {
	var (
		includeLastUsedTimeDefault = bool(false)
	)

	val := ListAllUsersParams{
		IncludeLastUsedTime: &includeLastUsedTimeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the list all users params
func (o *ListAllUsersParams) WithTimeout(timeout time.Duration) *ListAllUsersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list all users params
func (o *ListAllUsersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list all users params
func (o *ListAllUsersParams) WithContext(ctx context.Context) *ListAllUsersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list all users params
func (o *ListAllUsersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list all users params
func (o *ListAllUsersParams) WithHTTPClient(client *http.Client) *ListAllUsersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list all users params
func (o *ListAllUsersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIncludeLastUsedTime adds the includeLastUsedTime to the list all users params
func (o *ListAllUsersParams) WithIncludeLastUsedTime(includeLastUsedTime *bool) *ListAllUsersParams {
	o.SetIncludeLastUsedTime(includeLastUsedTime)
	return o
}

// SetIncludeLastUsedTime adds the includeLastUsedTime to the list all users params
func (o *ListAllUsersParams) SetIncludeLastUsedTime(includeLastUsedTime *bool) {
	o.IncludeLastUsedTime = includeLastUsedTime
}

// WriteToRequest writes these params to a swagger request
func (o *ListAllUsersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.IncludeLastUsedTime != nil {

		// query param includeLastUsedTime
		var qrIncludeLastUsedTime bool

		if o.IncludeLastUsedTime != nil {
			qrIncludeLastUsedTime = *o.IncludeLastUsedTime
		}
		qIncludeLastUsedTime := swag.FormatBool(qrIncludeLastUsedTime)
		if qIncludeLastUsedTime != "" {

			if err := r.SetQueryParam("includeLastUsedTime", qIncludeLastUsedTime); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
