//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package well_known

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/weaviate/weaviate/entities/models"
)

// GetWellKnownOpenidConfigurationReader is a Reader for the GetWellKnownOpenidConfiguration structure.
type GetWellKnownOpenidConfigurationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetWellKnownOpenidConfigurationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetWellKnownOpenidConfigurationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewGetWellKnownOpenidConfigurationNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetWellKnownOpenidConfigurationInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewGetWellKnownOpenidConfigurationOK creates a GetWellKnownOpenidConfigurationOK with default headers values
func NewGetWellKnownOpenidConfigurationOK() *GetWellKnownOpenidConfigurationOK {
	return &GetWellKnownOpenidConfigurationOK{}
}

/*
GetWellKnownOpenidConfigurationOK describes a response with status code 200, with default header values.

OIDC configuration details returned successfully.
*/
type GetWellKnownOpenidConfigurationOK struct {
	Payload *GetWellKnownOpenidConfigurationOKBody
}

// IsSuccess returns true when this get well known openid configuration o k response has a 2xx status code
func (o *GetWellKnownOpenidConfigurationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get well known openid configuration o k response has a 3xx status code
func (o *GetWellKnownOpenidConfigurationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get well known openid configuration o k response has a 4xx status code
func (o *GetWellKnownOpenidConfigurationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get well known openid configuration o k response has a 5xx status code
func (o *GetWellKnownOpenidConfigurationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get well known openid configuration o k response a status code equal to that given
func (o *GetWellKnownOpenidConfigurationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get well known openid configuration o k response
func (o *GetWellKnownOpenidConfigurationOK) Code() int {
	return 200
}

func (o *GetWellKnownOpenidConfigurationOK) Error() string {
	return fmt.Sprintf("[GET /.well-known/openid-configuration][%d] getWellKnownOpenidConfigurationOK  %+v", 200, o.Payload)
}

func (o *GetWellKnownOpenidConfigurationOK) String() string {
	return fmt.Sprintf("[GET /.well-known/openid-configuration][%d] getWellKnownOpenidConfigurationOK  %+v", 200, o.Payload)
}

func (o *GetWellKnownOpenidConfigurationOK) GetPayload() *GetWellKnownOpenidConfigurationOKBody {
	return o.Payload
}

func (o *GetWellKnownOpenidConfigurationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(GetWellKnownOpenidConfigurationOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetWellKnownOpenidConfigurationNotFound creates a GetWellKnownOpenidConfigurationNotFound with default headers values
func NewGetWellKnownOpenidConfigurationNotFound() *GetWellKnownOpenidConfigurationNotFound {
	return &GetWellKnownOpenidConfigurationNotFound{}
}

/*
GetWellKnownOpenidConfigurationNotFound describes a response with status code 404, with default header values.

OIDC provider is not configured for this Weaviate instance.
*/
type GetWellKnownOpenidConfigurationNotFound struct {
}

// IsSuccess returns true when this get well known openid configuration not found response has a 2xx status code
func (o *GetWellKnownOpenidConfigurationNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get well known openid configuration not found response has a 3xx status code
func (o *GetWellKnownOpenidConfigurationNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get well known openid configuration not found response has a 4xx status code
func (o *GetWellKnownOpenidConfigurationNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get well known openid configuration not found response has a 5xx status code
func (o *GetWellKnownOpenidConfigurationNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get well known openid configuration not found response a status code equal to that given
func (o *GetWellKnownOpenidConfigurationNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get well known openid configuration not found response
func (o *GetWellKnownOpenidConfigurationNotFound) Code() int {
	return 404
}

func (o *GetWellKnownOpenidConfigurationNotFound) Error() string {
	return fmt.Sprintf("[GET /.well-known/openid-configuration][%d] getWellKnownOpenidConfigurationNotFound ", 404)
}

func (o *GetWellKnownOpenidConfigurationNotFound) String() string {
	return fmt.Sprintf("[GET /.well-known/openid-configuration][%d] getWellKnownOpenidConfigurationNotFound ", 404)
}

func (o *GetWellKnownOpenidConfigurationNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewGetWellKnownOpenidConfigurationInternalServerError creates a GetWellKnownOpenidConfigurationInternalServerError with default headers values
func NewGetWellKnownOpenidConfigurationInternalServerError() *GetWellKnownOpenidConfigurationInternalServerError {
	return &GetWellKnownOpenidConfigurationInternalServerError{}
}

/*
GetWellKnownOpenidConfigurationInternalServerError describes a response with status code 500, with default header values.

An internal server error occurred while retrieving OIDC configuration. Check the ErrorResponse for details.
*/
type GetWellKnownOpenidConfigurationInternalServerError struct {
	Payload *models.ErrorResponse
}

// IsSuccess returns true when this get well known openid configuration internal server error response has a 2xx status code
func (o *GetWellKnownOpenidConfigurationInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get well known openid configuration internal server error response has a 3xx status code
func (o *GetWellKnownOpenidConfigurationInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get well known openid configuration internal server error response has a 4xx status code
func (o *GetWellKnownOpenidConfigurationInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get well known openid configuration internal server error response has a 5xx status code
func (o *GetWellKnownOpenidConfigurationInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get well known openid configuration internal server error response a status code equal to that given
func (o *GetWellKnownOpenidConfigurationInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get well known openid configuration internal server error response
func (o *GetWellKnownOpenidConfigurationInternalServerError) Code() int {
	return 500
}

func (o *GetWellKnownOpenidConfigurationInternalServerError) Error() string {
	return fmt.Sprintf("[GET /.well-known/openid-configuration][%d] getWellKnownOpenidConfigurationInternalServerError  %+v", 500, o.Payload)
}

func (o *GetWellKnownOpenidConfigurationInternalServerError) String() string {
	return fmt.Sprintf("[GET /.well-known/openid-configuration][%d] getWellKnownOpenidConfigurationInternalServerError  %+v", 500, o.Payload)
}

func (o *GetWellKnownOpenidConfigurationInternalServerError) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *GetWellKnownOpenidConfigurationInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
GetWellKnownOpenidConfigurationOKBody get well known openid configuration o k body
swagger:model GetWellKnownOpenidConfigurationOKBody
*/
type GetWellKnownOpenidConfigurationOKBody struct {

	// The OAuth Client ID configured for Weaviate.
	ClientID string `json:"clientId,omitempty"`

	// The OIDC issuer URL to redirect to for authentication.
	Href string `json:"href,omitempty"`

	// The required OAuth scopes for authentication.
	Scopes []string `json:"scopes,omitempty"`
}

// Validate validates this get well known openid configuration o k body
func (o *GetWellKnownOpenidConfigurationOKBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this get well known openid configuration o k body based on context it is used
func (o *GetWellKnownOpenidConfigurationOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *GetWellKnownOpenidConfigurationOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *GetWellKnownOpenidConfigurationOKBody) UnmarshalBinary(b []byte) error {
	var res GetWellKnownOpenidConfigurationOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
