//                           _       _
// __      _____  __ ___   ___  __ _| |_ ___
// \ \ /\ / / _ \/ _` \ \ / / |/ _` | __/ _ \
//  \ V  V /  __/ (_| |\ V /| | (_| | ||  __/
//   \_/\_/ \___|\__,_| \_/ |_|\__,_|\__\___|
//
//  Copyright © 2016 - 2026 Weaviate B.V. All rights reserved.
//
//  CONTACT: hello@weaviate.io
//

// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// AliasResponse Response object containing a list of alias mappings.
//
// swagger:model AliasResponse
type AliasResponse struct {

	// Array of alias objects, each containing an alias-to-collection mapping.
	Aliases []*Alias `json:"aliases"`
}

// Validate validates this alias response
func (m *AliasResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAliases(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AliasResponse) validateAliases(formats strfmt.Registry) error {
	if swag.IsZero(m.Aliases) { // not required
		return nil
	}

	for i := 0; i < len(m.Aliases); i++ {
		if swag.IsZero(m.Aliases[i]) { // not required
			continue
		}

		if m.Aliases[i] != nil {
			if err := m.Aliases[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aliases" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("aliases" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this alias response based on the context it is used
func (m *AliasResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAliases(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *AliasResponse) contextValidateAliases(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Aliases); i++ {

		if m.Aliases[i] != nil {
			if err := m.Aliases[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("aliases" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("aliases" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *AliasResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AliasResponse) UnmarshalBinary(b []byte) error {
	var res AliasResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
